/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.service.impl;

import java.util.List;
import java.util.Map;
import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.dto.TxInvokerAttachment;
import kd.bos.kdtx.common.entity.BranchExecuteInfo;
import kd.bos.kdtx.common.entity.BusinessEntryInfo;
import kd.bos.kdtx.common.entity.TxBusinessInfo;
import kd.bos.kdtx.common.entity.TxLogInfo;
import kd.bos.kdtx.common.entity.TxRetryInfo;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.param.BranchActionParam;
import kd.bos.kdtx.common.param.BusinessParam;
import kd.bos.kdtx.common.param.ListTxInfoParam;
import kd.bos.kdtx.common.param.ListTxLogParam;
import kd.bos.kdtx.common.param.TxActionParam;
import kd.bos.kdtx.common.response.CompensateResponse;
import kd.bos.kdtx.common.service.DtxTxDispatchService;
import kd.bos.kdtx.server.compensate.CompensateService;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.context.TcContextUtil;
import kd.bos.kdtx.server.service.TransCoordinatorService;
import kd.bos.kdtx.server.service.impl.TransCoordinatorServiceImpl;
import kd.bos.kdtx.server.service.impl.TxCommonService;
import kd.bos.kdtx.server.state.LookupLocalUtils;
import kd.bos.util.StringUtils;

public class TxDispatchServiceImpl
implements DtxTxDispatchService {
    private final CompensateService compensateService = CompensateService.getCompensateService();
    private final TransCoordinatorService transCoordinatorServiceImpl = new TransCoordinatorServiceImpl();

    private void nestContextDeal() {
        TcContext tc = TcContext.get();
        if (tc != null && LookupLocalUtils.isLookUplocal() && StringUtils.isNotEmpty((String)KdtxRequestContext.get().getXid())) {
            if (TcContextUtil.getTcContext(tc.getXid()) == null) {
                TcContextUtil.putTcContext(tc.getXid(), tc);
            }
            TcContext.remove();
        }
    }

    public void begin(String code, String txType, TxBusinessInfo txBusinessInfo, boolean runModel, String dbRoute) throws Exception {
        TxActionParam param = new TxActionParam();
        param.setTxCode(code);
        param.setTxType(txType);
        param.setTxBusinessInfo(txBusinessInfo);
        this.nestContextDeal();
        TcContext.getOrCreate().setRunMqModel(runModel);
        if (!StringUtils.isEmpty((String)dbRoute)) {
            TcContext.get().setDbRoute(dbRoute);
        }
        this.invokeHandleTx(ActionType.TX_BEGIN, param);
    }

    public void commit(boolean async, TxInvokerAttachment commitAttachment) throws Exception {
        String xid = KdtxRequestContext.get().getXid();
        TxCommonService.setCallback(commitAttachment);
        TcContext.getOrCreate().setAsyncCommit(async);
        this.invokeHandleTx(ActionType.TX_COMMIT);
        TcContextUtil.remove(xid);
    }

    public void rollback(boolean async, TxInvokerAttachment rollbackAttachment) throws Exception {
        String xid = KdtxRequestContext.get().getXid();
        TxCommonService.setCallback(rollbackAttachment);
        TcContext.getOrCreate().setAsyncRollback(async);
        this.invokeHandleTx(ActionType.TX_ROLLBACK);
        TcContextUtil.remove(xid);
    }

    private void invokeHandleTx(ActionType actionType) throws Exception {
        this.invokeHandleTx(actionType, null);
    }

    private void invokeHandleTx(ActionType actionType, TxActionParam param) throws Exception {
        try {
            this.transCoordinatorServiceImpl.proxyHandleTx(actionType, param);
        }
        finally {
            TcContext.remove();
        }
    }

    public void branchRegister(BranchActionParam param) throws Exception {
        try {
            this.transCoordinatorServiceImpl.proxyHandleBranch(ActionType.BRANCH_REGISTER, param);
        }
        finally {
            TcContext.remove();
        }
    }

    public void setBusinessInfo(TxBusinessInfo txBusinessInfo) throws Exception {
        TxActionParam param = new TxActionParam();
        param.setTxBusinessInfo(txBusinessInfo);
        this.invokeHandleTx(ActionType.SET_BUSINESS_INFO, param);
    }

    public void registerCascadeBranch(BranchActionParam param) throws Exception {
        this.transCoordinatorServiceImpl.proxyHandleBranch(ActionType.CASCADE_BRANCH_REGISTER, param);
    }

    public void branchReport(BranchActionParam param) throws Exception {
        try {
            this.transCoordinatorServiceImpl.proxyHandleBranch(ActionType.BRANCH_REPORT, param);
        }
        finally {
            TcContext.remove();
        }
    }

    public CompensateResponse manuallyRetry(List<Map<String, String>> info) {
        return this.compensateService.manuallyRetry(info);
    }

    public CompensateResponse prepareTimeoutRollback(List<String> xids) {
        return this.compensateService.prepareTimeoutRollback(xids);
    }

    public List<TxRetryInfo> listTxInfoDataSet(ListTxInfoParam listTxInfoParam) {
        return this.compensateService.listTxInfoDataSet(listTxInfoParam);
    }

    public List<TxLogInfo> listTxLog(ListTxLogParam listTxLogParam) {
        return this.compensateService.listTxLog(listTxLogParam);
    }

    public List<TxSceneInfo> queryTxSceneInfo() {
        return this.compensateService.queryTxSceneInfo();
    }

    public void insertOrUpdateTxSceneInfo(TxSceneInfo txSceneInfo) {
        this.compensateService.insertOrUpdateTxSceneInfo(txSceneInfo);
    }

    public TxSceneInfo getTxSceneInfoById(String id) {
        return this.compensateService.getTxSceneInfoById(id);
    }

    public List<TxBusinessInfo> queryTxBusinessInfo(String businessType, List<String> businessIds) {
        return this.compensateService.queryBusinessInfo(businessType, businessIds);
    }

    public List<BusinessEntryInfo> queryBusinessEntry(BusinessParam param) {
        return this.compensateService.queryBusinessEntry(param);
    }

    public void unlockBusinessOrder(String xid) {
        this.compensateService.unlockBusinessOrder(xid);
    }

    public Map<String, List<BranchExecuteInfo>> queryRelativeTxBranchExecuteInfos(String businessId) {
        return TxCommonService.queryRelativeTxBranchExecuteInfos(businessId);
    }
}

