/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.state;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.BranchStatus;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.Status;
import kd.bos.kdtx.common.entity.TxBranchInfo;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.exception.BranchCommitFailException;
import kd.bos.kdtx.common.util.EnumUtils;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.state.AccountInfo;
import kd.bos.kdtx.server.state.TcState;
import kd.bos.kdtx.server.tasks.ReportCommittingTask;
import kd.bos.kdtx.server.tasks.ReportRollbackingTask;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;
import kd.bos.util.StringUtils;

public abstract class BaseTcState
implements TcState {
    private static ScheduledExecutorService scheduledExecutorService;
    private static ConcurrentHashMap<String, AccountInfo> committingMap;
    private static ConcurrentHashMap<String, AtomicInteger> mqModelCommitting;
    private static ConcurrentHashMap<String, AccountInfo> rollbackingMap;
    protected String name;
    protected int txType;
    protected GlobalTxStatus state;

    public boolean existTransaction(TxInfo txInfo, GlobalTxStatus ... globalTxStatuses) {
        String signCode = txInfo.getFsignCode();
        if (StringUtils.isEmpty((String)signCode)) {
            return true;
        }
        String xid = txInfo.getFxid();
        String sql = "SELECT TOP 1 ctt.fid FROM t_cbs_dtx_transaction ctt WHERE ctt.fsign_code = ? AND ctt.fstatus IN ( %s ) AND ctt.fxid != ? AND ctt.fcreate_time < (SELECT ct.fcreate_time FROM t_cbs_dtx_transaction ct WHERE ct.fxid = ?) ";
        String status = EnumUtils.toString((Status[])globalTxStatuses);
        sql = String.format(sql, status);
        Object[] params = new Object[]{signCode, xid, xid};
        long txId = (Long)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, resultSet -> {
            long id = 0L;
            while (resultSet.next()) {
                id = resultSet.getLong("fid");
            }
            return id;
        });
        return txId > 0L;
    }

    public TxInfo getTransactionInfo() {
        String xid = TcContext.get().getXid();
        String sql = "select ftx_type, fscenes_tx_id ,fserializer,ftx_type,froutekey from t_cbs_dtx_transaction where fxid = ?";
        TxInfo txInfo = new TxInfo();
        return (TxInfo)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{xid}, resultSet -> {
            if (resultSet.next()) {
                txInfo.setFtxType(resultSet.getInt("ftx_type"));
                txInfo.setFscenesTxId(resultSet.getLong("fscenes_tx_id"));
                txInfo.setSerializer(resultSet.getString("fserializer"));
                txInfo.setFtxType(resultSet.getInt("ftx_type"));
                txInfo.setRouteKey(resultSet.getString("froutekey"));
            }
            txInfo.setFxid(xid);
            return txInfo;
        });
    }

    protected List<TxBranchInfo> getCascadeBranch(String xid, String branchId) {
        Object[] params = new Object[]{xid, branchId};
        String sql = "SELECT fresource, fparas, fid, fstatus, fbranch_id, fseq FROM t_cbs_dtx_branch WHERE fxid = ? AND (fparent_branch_id = ?) ";
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            ArrayList<TxBranchInfo> ret = new ArrayList<TxBranchInfo>(8);
            while (rs.next()) {
                TxBranchInfo txBranchInfo = new TxBranchInfo();
                txBranchInfo.setResource(rs.getString(1));
                txBranchInfo.setParas(rs.getString(2));
                txBranchInfo.setId(rs.getLong(3));
                txBranchInfo.setBranchStatus(rs.getInt(4));
                txBranchInfo.setBranchId(rs.getString(5));
                txBranchInfo.setSeq(rs.getLong(6));
                ret.add(txBranchInfo);
            }
            return ret;
        });
    }

    protected List<TxBranchInfo> queryBranches(BranchStatus ... branchStatuses) {
        String xid = TcContext.get().getXid();
        String status = EnumUtils.toString((Status[])branchStatuses);
        Object[] params = new Object[]{xid};
        String sql = "SELECT fresource, fparas, fid, fstatus, fbranch_id, fseq,fparas_bytes FROM t_cbs_dtx_branch WHERE fxid = ? AND (fparent_branch_id is null or fparent_branch_id = '' or fparent_branch_id = ' ') AND fstatus IN ( %s )  ORDER BY fseq ASC ";
        sql = String.format(sql, status);
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            ArrayList<TxBranchInfo> ret = new ArrayList<TxBranchInfo>(8);
            while (rs.next()) {
                TxBranchInfo txBranchInfo = new TxBranchInfo();
                txBranchInfo.setResource(rs.getString(1));
                txBranchInfo.setParas(rs.getString(2));
                txBranchInfo.setId(rs.getLong(3));
                txBranchInfo.setBranchStatus(rs.getInt(4));
                txBranchInfo.setBranchId(rs.getString(5));
                txBranchInfo.setSeq(rs.getLong(6));
                txBranchInfo.setParasBytes(rs.getBytes(7));
                ret.add(txBranchInfo);
            }
            return ret;
        });
    }

    public void assertNestChildCommitFaild(String xid, String branchId) {
        String sql = "SELECT top 1, 0 fxid, fstatus FROM t_cbs_dtx_transaction WHERE fparent_xid = ? AND fsource_branch_id= ? ORDER BY fcreate_time DESC";
        try (DataSet dataSet = DB.queryDataSet((String)"assertNestChildCommitFaild", (DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{xid, branchId});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String childXid = row.getString("fxid");
                int status = row.getInteger("fstatus");
                if (status != GlobalTxStatus.COMMIT_FAILED.getCode()) continue;
                throw new BranchCommitFailException("the transaction[" + xid + "]'s branch[" + branchId + "]has nest child transaction[" + childXid + "] not completed");
            }
        }
    }

    public GlobalTxStatus getState() {
        return this.state;
    }

    public void setTxType(int txType) {
        this.txType = txType;
    }

    protected void committingMapAdd(String xid, boolean mqModel) {
        if (this.isReport()) {
            this.startReportSchedule();
            committingMap.put(xid, this.getCurrentAccount());
            if (mqModel) {
                AtomicInteger count = mqModelCommitting.computeIfAbsent(xid, k -> new AtomicInteger(0));
                count.incrementAndGet();
            }
        }
    }

    protected void rollbackingMapAdd(String xid) {
        if (this.isReport()) {
            this.startReportSchedule();
            rollbackingMap.put(xid, this.getCurrentAccount());
        }
    }

    protected void committingMapRemove(String xid, boolean mqModel) {
        if (this.isReport()) {
            AtomicInteger count;
            if (mqModel && mqModelCommitting.containsKey(xid) && (count = mqModelCommitting.get(xid)).decrementAndGet() != 0) {
                return;
            }
            committingMap.remove(xid);
            mqModelCommitting.remove(xid);
        }
    }

    protected void rollbackingMapRemove(String xid) {
        if (this.isReport()) {
            rollbackingMap.remove(xid);
        }
    }

    public static ConcurrentHashMap<String, AccountInfo> getCommittingMap() {
        return committingMap;
    }

    public static ConcurrentHashMap<String, AccountInfo> getRollbackingMap() {
        return rollbackingMap;
    }

    public static ConcurrentHashMap<String, AtomicInteger> getMqCommittingMap() {
        return mqModelCommitting;
    }

    private AccountInfo getCurrentAccount() {
        AccountInfo account = new AccountInfo();
        account.setAccountId(RequestContext.get().getAccountId());
        account.setTenantId(RequestContext.get().getTenantId());
        account.setCreated(new Date());
        return account;
    }

    private boolean isReport() {
        String isReport = System.getProperty("kdtx.longdtx.report.startup", "true");
        return Boolean.parseBoolean(isReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startReportSchedule() {
        if (scheduledExecutorService != null) return;
        Class<BaseTcState> clazz = BaseTcState.class;
        synchronized (BaseTcState.class) {
            if (scheduledExecutorService != null) return;
            scheduledExecutorService = Executors.newScheduledThreadPool(1, r -> new Thread(r, "kdtx-longtx-report"));
            scheduledExecutorService.scheduleWithFixedDelay(new ReportCommittingTask(), 0L, TransCoordinatorConfig.getLongDtxReportDelay(), TimeUnit.SECONDS);
            scheduledExecutorService.scheduleWithFixedDelay(new ReportRollbackingTask(), 0L, TransCoordinatorConfig.getLongDtxReportDelay(), TimeUnit.SECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void saveBusinessInfo(TxSceneInfo txSceneInfo) {
        String businessType = TcContext.get().getContextBusinessType();
        String xid = TcContext.get().getXid();
        if (StringUtils.isEmpty((String)businessType) && StringUtils.isEmpty((String)(businessType = txSceneInfo.getBusinessType())) && this.isTccType()) {
            businessType = "TCC_DEFAULT_LOCK_TYPE";
        }
        String insertBusSql = "INSERT INTO t_cbs_dtx_business(fid,fxid,fbusiness_id,fbusiness_type,fcreate_time) VALUES(?,?,?,?,now())";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1000);
        List<String> contextBusinessIds = TcContext.get().getContextBusinessIds();
        List<String> repeatBusinessIds = this.getRepeatBusinessIds(xid, contextBusinessIds, businessType);
        List distinctList = contextBusinessIds.stream().distinct().filter(id -> !repeatBusinessIds.contains(id)).collect(Collectors.toList());
        List partition = Lists.partition(distinctList, (int)1000);
        for (List list : partition) {
            paramList.clear();
            for (String businessId : list) {
                Object[] busParams = new Object[]{ID.genLongId(), xid, businessId, businessType};
                paramList.add(busParams);
            }
            try {
                MultiDBWriteHandler.execute(() -> DB.executeBatch((DBRoute)DBRoute.base, (String)insertBusSql, (List)paramList));
            }
            catch (Exception e) {
                break;
            }
        }
    }

    private List<String> getRepeatBusinessIds(String xid, List<String> contextBusinessIds, String businessType) {
        String queryRepeatSql = "select fbusiness_id from t_cbs_dtx_business where fxid = ? and fbusiness_type = ? and ";
        SqlBuilder builder = new SqlBuilder();
        builder.append(queryRepeatSql, new Object[]{xid, businessType});
        builder.appendIn("fbusiness_id", contextBusinessIds.toArray());
        return (List)DB.query((DBRoute)DBRoute.base, (SqlBuilder)builder, rs -> {
            ArrayList<String> repeatList = new ArrayList<String>(8);
            while (rs.next()) {
                repeatList.add(rs.getString(1));
            }
            return repeatList;
        });
    }

    private boolean isTccType() {
        int txType = TcContext.get() != null && StringUtils.isNotEmpty((String)TcContext.get().getTxType()) ? Integer.parseInt(TcContext.get().getTxType()) : KdtxRequestContext.get().getDtxType();
        return txType == DtxType.TCC.getCode();
    }

    static {
        committingMap = new ConcurrentHashMap();
        mqModelCommitting = new ConcurrentHashMap();
        rollbackingMap = new ConcurrentHashMap();
    }
}

