/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.state.adapter;

import java.util.ArrayList;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.constant.BranchStatus;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.constant.Status;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.util.EnumUtils;
import kd.bos.kdtx.server.state.adapter.UpdateTxAdapter;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;

public abstract class UpdateBranchAdapter
extends UpdateTxAdapter {
    @Override
    public boolean updateBranch(long id, BranchStatus branchStatus, BranchStatus[] originalStatuses) throws Exception {
        return this.updateBranch(id, branchStatus, null, originalStatuses);
    }

    public boolean updateBranch(long id, BranchStatus branchStatus, byte[] result, BranchStatus[] originalStatuses) throws Exception {
        if (originalStatuses == null || originalStatuses.length == 0) {
            ExceptionLogger.error(UpdateBranchAdapter.class, (String)"originalStatuses is empty!");
            throw new KdtxException();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(branchStatus.getCode());
        if (result != null) {
            paramList.add(result);
        }
        paramList.add(id);
        Object[] params = paramList.toArray();
        String sql = "UPDATE t_cbs_dtx_branch SET fstatus = ?, ";
        if (result != null) {
            sql = sql + "fresult = ?, ";
        }
        sql = sql + "fupdate_time = NOW() WHERE fid = ? AND fstatus in ( %s )";
        String endSql = sql = String.format(sql, EnumUtils.toString((Status[])originalStatuses));
        return (Integer)MultiDBWriteHandler.execute(() -> DB.update((DBRoute)DBRoute.base, (String)endSql, (Object[])params)) == 1;
    }

    public void updateSecondStatusPublished(TxInfo txInfo, long seq) {
        if (txInfo.getFtxType() == DtxType.SIMPLEEC.getCode()) {
            String sql = "UPDATE t_dtx_local_tx_log SET fstatus=? WHERE fxid=? and fseq=? and fstatus=?";
            Object[] params = new Object[]{LocalTxLogStatus.PUBLISHED.getCode(), txInfo.getFxid(), seq, LocalTxLogStatus.UNPUBLISHED.getCode()};
            MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.of((String)txInfo.getRouteKey()), (String)sql, (Object[])params));
        }
    }

    public boolean updateBranch(String xid, BranchStatus branchStatus, String result, BranchStatus[] originalStatuses) throws Exception {
        if (originalStatuses == null || originalStatuses.length == 0) {
            ExceptionLogger.error(UpdateBranchAdapter.class, (String)"originalStatuses is empty!");
            throw new KdtxException();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(branchStatus.getCode());
        if (result != null) {
            paramList.add(result);
        }
        paramList.add(xid);
        Object[] params = paramList.toArray();
        String sql = "UPDATE t_cbs_dtx_branch SET fstatus = ?, ";
        if (result != null) {
            sql = sql + "fresult = ?, ";
        }
        sql = sql + "fupdate_time = NOW() WHERE fxid = ? AND fstatus in ( %s )";
        String endSql = sql = String.format(sql, EnumUtils.toString((Status[])originalStatuses));
        return (Integer)MultiDBWriteHandler.execute(() -> DB.update((DBRoute)DBRoute.base, (String)endSql, (Object[])params)) == 1;
    }
}

