/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.state.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.BranchStatus;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.InvokeType;
import kd.bos.kdtx.common.entity.TxBranchInfo;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.exception.invoke.BranchBizException;
import kd.bos.kdtx.common.invoke.Attachment;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.common.invoke.factory.InvokerFactory;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.context.TcContextUtil;
import kd.bos.kdtx.server.log.TCCDBLogger;
import kd.bos.kdtx.server.state.LookupLocalUtils;
import kd.bos.kdtx.server.state.adapter.UpdateBranchAdapter;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;
import kd.bos.monitor.sdk.KDCounter;

public class CommittingState
extends UpdateBranchAdapter {
    public static final KDCounter counterTry = KDCounter.build((String)"kdtx_commit_try", (String)"KDTX try to commit counter", (String[])new String[]{"tx_type"});
    public static final KDCounter counterError = KDCounter.build((String)"kdtx_commit_error", (String)"KDTX commit error counter", (String[])new String[]{"tx_type"});
    private static final int TIMEOUT = CommittingState.getTimeout();
    private static final int LOOP_MAX_COUNT = CommittingState.getLoopMaxCount();
    private static final BranchStatus[] PCC_STATUS = new BranchStatus[]{BranchStatus.PREPARING, BranchStatus.COMMIT_FAILED, BranchStatus.COMMITTING};
    private static final BranchStatus[] COMMITTING_STATUS = new BranchStatus[]{BranchStatus.COMMITTING};

    public CommittingState() {
        this.name = GlobalTxStatus.COMMITTING.getName();
        this.state = GlobalTxStatus.COMMITTING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(TxBranchInfo branchInfo) throws Exception {
        String committingXid = KdtxRequestContext.get().getXid();
        boolean isMqModel = branchInfo != null;
        try {
            this.committingMapAdd(committingXid, isMqModel);
            boolean shouldFail = false;
            ArrayList<String> failBranchIds = new ArrayList<String>(8);
            ArrayList<TxBranchInfo> txBranchInfoList = new ArrayList<TxBranchInfo>();
            if (!isMqModel) {
                txBranchInfoList.addAll(this.queryBranches(BranchStatus.PREPARING, BranchStatus.COMMIT_FAILED, BranchStatus.COMMITTING));
            } else {
                txBranchInfoList.add(branchInfo);
            }
            String remark = null;
            TxInfo txInfo = this.getTransactionInfo();
            Attachment attachment = this.generalAttachment(txInfo);
            String txType = txInfo.getFtxType() == 0 ? "TCC" : "EC";
            counterTry.labels(new String[]{txType}).inc();
            for (TxBranchInfo txBranchInfo : txBranchInfoList) {
                long sid = txBranchInfo.getId();
                KdtxRequestContext.get().setBranchId(txBranchInfo.getBranchId());
                TcContext bakTcContext = TcContext.copy(TcContext.get());
                this.updateBranch(sid, BranchStatus.COMMITTING, PCC_STATUS);
                this.updateCascadeBranchStatus(TcContext.get().getXid(), txBranchInfo.getBranchId());
                long logId = -1L;
                if (branchInfo == null) {
                    logId = TCCDBLogger.insertActionLog(ActionType.BRANCH_COMMIT, txBranchInfo.getBranchId());
                }
                int result = 0;
                try {
                    KdtxRequestContext.get().setBranchId(txBranchInfo.getBranchId());
                    byte[] lastReturn = this.invoke(txBranchInfo.getParas(), txBranchInfo.getParasBytes(), branchInfo == null ? this.getLastReturn(txBranchInfo.getSeq()) : null, attachment);
                    this.updateSecondStatusPublished(txInfo, txBranchInfo.getSeq());
                    this.updateBranch(sid, BranchStatus.COMMITTED, lastReturn, COMMITTING_STATUS);
                    result = 1;
                }
                catch (Exception e) {
                    result = -1;
                    remark = BranchBizException.extractBizExceptionStack((Exception)e);
                    this.updateBranch(sid, BranchStatus.COMMIT_FAILED, COMMITTING_STATUS);
                    shouldFail = true;
                    failBranchIds.add(txBranchInfo.getBranchId());
                    ExceptionLogger.error(CommittingState.class, (String)("KdtxMonitorLog branch commit! xid: " + txBranchInfo.getXid() + " branchId: " + txBranchInfo.getBranchId()), (Throwable)e);
                    counterError.labels(new String[]{txType}).inc();
                    break;
                }
                finally {
                    this.restoreParentContext(txBranchInfo.getBranchId());
                    if (branchInfo == null) {
                        TCCDBLogger.updateActionLog(logId, ActionType.BRANCH_COMMIT, result, remark);
                    }
                    KdtxRequestContext.get().setBranchId(null);
                    TcContext.set(bakTcContext);
                }
            }
            if (shouldFail) {
                throw new KdtxException("branch commit failed! Fail branch id: " + ((Object)failBranchIds).toString() + "; one fail reason:" + remark);
            }
        }
        finally {
            this.committingMapRemove(committingXid, isMqModel);
        }
    }

    private void restoreParentContext(String branchId) {
        String branchHasChildTx;
        boolean existChildTx;
        TcContext parentContext = TcContextUtil.getTcContext(KdtxRequestContext.get().getXid());
        if (LookupLocalUtils.isLookUplocal() && parentContext != null && (existChildTx = ((Boolean)DB.query((DBRoute)DBRoute.basedata, (String)(branchHasChildTx = "select fxid from t_cbs_dtx_transaction where fsource_branch_id=?"), (Object[])new Object[]{branchId}, ResultSet::next)).booleanValue())) {
            TcContext.set(parentContext);
        }
    }

    private void updateCascadeBranchStatus(String xid, String currentBranchId) throws Exception {
        List<TxBranchInfo> cascadeBranch;
        if (TcContext.get().isRetry() && (cascadeBranch = this.getCascadeBranch(xid, currentBranchId)) != null && cascadeBranch.size() > 0) {
            this.updateCascadeBranch(xid, currentBranchId, BranchStatus.DISCARD);
        }
    }

    private boolean updateCascadeBranch(String xid, String parentBranchId, BranchStatus branchStatus) throws Exception {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(branchStatus.getCode());
        paramList.add(xid);
        paramList.add(parentBranchId);
        Object[] params = paramList.toArray();
        String sql = "UPDATE t_cbs_dtx_branch SET fstatus = ?, fupdate_time = NOW() WHERE fxid = ? AND fparent_branch_id =? ";
        return (Integer)MultiDBWriteHandler.execute(() -> DB.update((DBRoute)DBRoute.base, (String)sql, (Object[])params)) == 1;
    }

    private static int getTimeout() {
        int txCommitRetries = DtxConfig.getTxCommitRetries();
        int txCommitTimeout = DtxConfig.getTxCommitTimeout();
        return txCommitTimeout * txCommitRetries + 60000;
    }

    private static int getLoopMaxCount() {
        int txCommitRetries = DtxConfig.getTxCommitRetries();
        int txCommitTimeout = DtxConfig.getTxCommitTimeout();
        return txCommitTimeout / 1000 * txCommitRetries + 120;
    }

    private byte[] invoke(String paras, byte[] parasBytes, byte[] lastReturn, Attachment attachment) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        DtxParas tccParas = (DtxParas)objectMapper.readValue(paras, DtxParas.class);
        tccParas.setLastReturn(lastReturn);
        tccParas.setParasBytes(parasBytes);
        tccParas.setAttachment(attachment);
        DtxResponse tccResponse = (DtxResponse)InvokerFactory.getTCCInvoker((InvokeType)InvokeType.BRANCH_COMMIT).doInvoke(tccParas);
        byte[] ret = null;
        if (tccResponse != null && Boolean.parseBoolean(System.getProperty("kdtx.support.lastReturn", "true"))) {
            ret = JsonUtils.serialization((Object)tccResponse);
        }
        return ret;
    }

    private byte[] getLastReturn(long seq) {
        if (seq <= 0L) {
            return null;
        }
        String xid = TcContext.get().getXid();
        Object[] params = new Object[]{xid, xid, seq};
        String querySql = "SELECT fresult FROM t_cbs_dtx_branch WHERE fxid = ? and fseq = ( SELECT MAX(fseq) FROM t_cbs_dtx_branch WHERE fxid = ? AND FSEQ < ? );";
        byte[] result = (byte[])DB.query((DBRoute)DBRoute.base, (String)querySql, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getBytes(1);
            }
            return null;
        });
        return result;
    }

    private Attachment generalAttachment(TxInfo txInfo) {
        Attachment attachment = new Attachment();
        attachment.setSerializer(txInfo.getSerializer());
        return attachment;
    }
}

