/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.state.impl;

import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.DtxModel;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.entity.TempContextInfo;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.TxBeginException;
import kd.bos.kdtx.common.util.AssertUtils;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.state.adapter.BaseTcAdapter;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class NotFoundState
extends BaseTcAdapter {
    public NotFoundState() {
        this.name = GlobalTxStatus.NOT_FOUND.getName();
        this.state = GlobalTxStatus.NOT_FOUND;
    }

    @Override
    public void saveTx() throws Exception {
        String model;
        String parentXid = null;
        if (KdtxRequestContext.get().getBranchId() != null) {
            parentXid = TcContext.get().getParentXid();
            AssertUtils.assertTrueAndLog((boolean)StringUtils.isNotEmpty((String)parentXid), (String)("KdtxMonitorLog can't find tx by parent branch id " + KdtxRequestContext.get().getBranchId()), (RuntimeException)new TxBeginException(DtxErrorCodeConstants.BRANCH_ID_NOT_MATCH_TRANSACTION));
        }
        String xid = TcContext.get().getXid();
        String txType = TcContext.get().getTxType();
        String txCode = TcContext.get().getTxCode();
        String string = model = TcContext.get().isRunMqModel() ? DtxModel.MQ.getCode() : DtxModel.RPC.getCode();
        if (StringUtils.isEmpty((String)txType)) {
            throw new TxBeginException(DtxErrorCodeConstants.TXTYPE_EMPTY);
        }
        if (StringUtils.isEmpty((String)txCode)) {
            throw new TxBeginException(DtxErrorCodeConstants.TXCODE_EMPTY);
        }
        Object[] queryParams = new Object[]{txCode};
        TxSceneInfo txSceneInfo = (TxSceneInfo)DB.query((DBRoute)DBRoute.base, (String)"SELECT fid,fbusiness_type FROM t_cbs_dtx_tx_scenes WHERE fcode = ?", (Object[])queryParams, rs -> {
            TxSceneInfo info = new TxSceneInfo();
            if (rs.next()) {
                info.setId(rs.getString("fid"));
                info.setBusinessType(rs.getString("fbusiness_type"));
            }
            return info;
        });
        if (txSceneInfo == null || StringUtils.isEmpty((String)txSceneInfo.getId())) {
            throw new TxBeginException(DtxErrorCodeConstants.TXCODE_ERROR, new Object[]{txCode});
        }
        TempContextInfo tempContextInfo = this.conventTempContext();
        String sql = "INSERT INTO t_cbs_dtx_transaction(fid, fxid, ftx_type, fscenes_tx_id, fstatus, ftenant_id, faccount_id, frollback_reason, froutekey, fmodel, fparent_xid, fsource_branch_id, fcontext, fcreator, fcreate_time, fupdate_time) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,now(),now())";
        Object[] params = new Object[]{ID.genLongId(), xid, Integer.parseInt(txType), Long.parseLong(txSceneInfo.getId()), GlobalTxStatus.PREPARING.getCode(), RequestContext.get().getTenantId(), Long.parseLong(RequestContext.get().getAccountId()), "", TcContext.get().getDbRoute() == null ? "" : TcContext.get().getDbRoute(), model, parentXid == null ? Character.valueOf(' ') : parentXid, KdtxRequestContext.get().getBranchId() == null ? Character.valueOf(' ') : KdtxRequestContext.get().getBranchId(), JsonUtils.getParasStr((Object)tempContextInfo), RequestContext.get().getCurrUserId()};
        boolean execute = (Boolean)MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params));
        if (execute && !CollectionUtils.isEmpty(TcContext.get().getContextBusinessIds())) {
            this.saveBusinessInfo(txSceneInfo);
        }
    }

    @Override
    public void updateTxDisCardByParentXid(String parentXid) {
        String branchSql = "update t_cbs_dtx_branch set fstatus=8 where fxid in (select cdt.fxid from t_cbs_dtx_transaction cdt where cdt.fparent_xid=? and fsource_branch_id=?)";
        String txSql = "update t_cbs_dtx_transaction set fstatus=8 where fparent_xid=? and fsource_branch_id=?";
        Object[] params = new Object[]{parentXid, KdtxRequestContext.get().getBranchId()};
        MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)branchSql, (Object[])params));
        MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)txSql, (Object[])params));
    }

    private TempContextInfo conventTempContext() {
        RequestContext rc = RequestContext.get();
        TempContextInfo context = new TempContextInfo();
        context.setUserId(rc.getCurrUserId());
        context.setAccountId(rc.getAccountId());
        context.setTenantId(rc.getTenantId());
        context.setTenantCode(rc.getTenantCode());
        context.setUserName(rc.getUserName());
        return context;
    }
}

