/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.state.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.dao.SceneDao;
import kd.bos.kdtx.common.exception.BranchRegisterException;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.state.adapter.UpdateTxAdapter;
import kd.bos.kdtx.server.tx.MultiDBWriteHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class PreparingState
extends UpdateTxAdapter {
    public static final String BIZTYPE = "kdtx-branch-bizId";
    private static Log logger = LogFactory.getLog(PreparingState.class);

    public PreparingState() {
        this.name = GlobalTxStatus.PREPARING.getName();
        this.state = GlobalTxStatus.PREPARING;
    }

    @Override
    public void registerBranch() throws Exception {
        long scenesBranchId = -1L;
        String txCode = TcContext.get().getTxCode();
        String branchCode = TcContext.get().getBranchCode();
        if (StringUtils.isNotEmpty((String)branchCode)) {
            if (StringUtils.isEmpty((String)txCode)) {
                throw new BranchRegisterException(DtxErrorCodeConstants.TXCODE_EMPTY);
            }
            scenesBranchId = SceneDao.getSceneBranchIdByCode((String)txCode, (String)branchCode);
        }
        if (DtxType.TCC.getCode() == this.getTxType()) {
            this.insertTCC(scenesBranchId);
            return;
        }
        this.insertEC(scenesBranchId);
    }

    private void insertTCC(long scenesBranchId) {
        String xid = TcContext.get().getXid();
        String rid = TcContext.get().getBranchId();
        String resource = TcContext.get().getResource();
        String paras = TcContext.get().getParas();
        String seqSql = "SELECT CASE WHEN (COUNT(1) = 0) THEN 0 ELSE MAX(fseq) + 1 END FROM t_cbs_dtx_branch WHERE fxid = ?";
        Object[] seqParams = new Object[]{xid};
        int seq = (Integer)DB.query((DBRoute)DBRoute.base, (String)seqSql, (Object[])seqParams, rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return null;
        });
        String sql = "INSERT INTO t_cbs_dtx_branch(fid, fxid, fseq, fbranch_id, fresource, fscenes_branch_id, fparas, fstatus, fcreate_time, fupdate_time,fparas_bytes) VALUES(?, ?, ?, ?, ?, ?, ?, ?, now(), now(),?)";
        Object[] params = new Object[]{ID.genLongId(), xid, seq, rid, resource, scenesBranchId, paras, GlobalTxStatus.PREPARING.getCode(), TcContext.get().getParasBytes() == null ? new Byte[]{} : (Byte[])TcContext.get().getParasBytes()};
        MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params));
        this.saveBranchBizId(rid + "");
    }

    private void insertEC(long scenesBranchId) {
        Long branchFid;
        long seq = Long.parseLong(TcContext.get().getContextBranchSeq());
        Object[] queryParams = new Object[]{TcContext.get().getXid(), seq};
        ActionType actionType = TcContext.get().getActionType();
        if (actionType != ActionType.CASCADE_BRANCH_REGISTER && (branchFid = (Long)DB.query((DBRoute)DBRoute.base, (String)"SELECT fid FROM t_cbs_dtx_branch WHERE fxid = ? AND fseq = ?", (Object[])queryParams, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return null;
        })) != null) {
            ExceptionLogger.info(PreparingState.class, (String)"KdtxMonitorLog branch tx is registered.");
            return;
        }
        String rid = TcContext.get().getBranchId();
        String resource = TcContext.get().getResource();
        String paras = TcContext.get().getParas();
        String sql = "INSERT INTO t_cbs_dtx_branch(fid, fxid, fseq, fbranch_id, fresource, fscenes_branch_id, fparas, fstatus, fcreate_time, fupdate_time,fparent_branch_id,fchild_seq,fparas_bytes) VALUES(?, ?, ?, ?, ?, ?, ?, ?, now(), now(),?,?,?)";
        int initStatus = GlobalTxStatus.PREPARING.getCode();
        if (TcContext.get().getLocalStatus() == LocalTxLogStatus.PUBLISHED.getCode() || TcContext.get().getLocalStatus() == LocalTxLogStatus.RECEIVED.getCode()) {
            initStatus = GlobalTxStatus.COMMITTED.getCode();
        }
        Object[] params = new Object[]{ID.genLongId(), TcContext.get().getXid(), seq, rid, resource, scenesBranchId, paras, initStatus, TcContext.get().getParentBranchId() == null ? "" : TcContext.get().getParentBranchId(), TcContext.get().getCascadeSeq() == null ? Long.valueOf(-1L) : TcContext.get().getCascadeSeq(), TcContext.get().getParasBytes() == null ? new Byte[]{} : (Byte[])TcContext.get().getParasBytes()};
        MultiDBWriteHandler.execute(() -> DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params));
        this.saveBranchBizId(rid + "");
    }

    private void saveBranchBizId(String branchId) {
        String xid = TcContext.get().getXid();
        String bizId = TcContext.get().getBizId();
        if (StringUtils.isEmpty((String)bizId)) {
            return;
        }
        String busSql = "INSERT INTO t_cbs_dtx_business(fid,fxid,fbranch_id,fbusiness_id,fbusiness_type,fcreate_time) VALUES(?,?,?,?,?,now())";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(1000);
        List<String> contextBusinessIds = this.convert2List(bizId);
        List distinctList = contextBusinessIds.stream().distinct().collect(Collectors.toList());
        List partition = Lists.partition(distinctList, (int)1000);
        for (List list : partition) {
            for (String businessId : list) {
                Object[] busParams = new Object[]{ID.genLongId(), xid, branchId, businessId, BIZTYPE};
                paramList.add(busParams);
            }
            try {
                MultiDBWriteHandler.execute(() -> DB.executeBatch((DBRoute)DBRoute.base, (String)busSql, (List)paramList));
            }
            catch (Exception e) {
                logger.warn("branch bizIds save fail", (Throwable)e);
            }
            paramList.clear();
        }
    }

    private List<String> convert2List(String bizIds) {
        if (StringUtils.isNotEmpty((String)bizIds)) {
            HashSet<String> set = new HashSet<String>(16);
            String[] ids = bizIds.split(",");
            for (int i = 0; i < ids.length; ++i) {
                set.add(ids[i]);
            }
            return new ArrayList<String>(set);
        }
        return Collections.EMPTY_LIST;
    }
}

