/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.state.AccountInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;

public abstract class AbstractReportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(AbstractReportTask.class);
    private RequestContext context = null;

    protected void report(ConcurrentHashMap<String, AccountInfo> reportMap, GlobalTxStatus status) {
        for (Map.Entry<String, AccountInfo> entry : reportMap.entrySet()) {
            AccountInfo account = entry.getValue();
            Date created = account.getCreated();
            int lessDuration = TransCoordinatorConfig.getNotReportLessDuration();
            int moreDuration = TransCoordinatorConfig.getNotReportMoreDuration();
            if (created.after(this.getDate(12, -lessDuration)) || created.after(this.getDate(10, moreDuration))) continue;
            String xid = entry.getKey();
            logger.warn("Report long dtx start. xid: " + xid);
            this.context = RequestContext.create();
            this.context.setAccountId(account.getAccountId());
            this.context.setTenantId(account.getTenantId());
            this.context.setTraceId(TraceIdUtil.getCurrentTraceIdString());
            Object[] params = new Object[]{xid, status.getCode()};
            String updateSql = "UPDATE t_cbs_dtx_transaction SET fupdate_time = GETDATE() WHERE fxid = ? AND fstatus = ?";
            try (TXHandle tx = TX.requiresNew();){
                try {
                    DB.update((DBRoute)DBRoute.base, (String)updateSql, (Object[])params);
                }
                catch (Exception e) {
                    logger.error("report update_time error.", (Throwable)e);
                    tx.markRollback();
                }
            }
            logger.warn("long dtx is Reported");
        }
    }

    private Date getDate(int calendarField, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(calendarField, amount);
        return calendar.getTime();
    }
}

