/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.kdtx.server.compensate.CompensateService;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.tasks.template.LockTemplate;

public class AutoCompensateTask
extends LockTemplate {
    private static final String THREAD_NAME = "AutoCompensateTask-Thread";
    private static final String LOCK_KEY = "kdtx.AutoCompensate-task";
    private final CompensateService compensateService = CompensateService.getCompensateService();
    private static final int ONECE_LIMIT = 1000;
    private static final String QUERY_EXPIRE_AUTO_COMPENSATE_SQL = "select distinct sc.fxid,rs.fseq from t_cbs_dtx_retry_schedule sc left join t_cbs_dtx_retry_stat rs on sc.fxid=rs.fxid where sc.fschedule_time <= now()";

    public AutoCompensateTask() {
        super.setThreadName(THREAD_NAME);
        super.setLockKey(LOCK_KEY);
    }

    @Override
    public void execute() {
        if (DB.exitsTable((DBRoute)DBRoute.basedata, (String)"t_cbs_dtx_retry_schedule")) {
            ArrayList<Map<String, String>> toBeCompensates = new ArrayList<Map<String, String>>(1);
            ArrayList xids = new ArrayList();
            DB.query((DBRoute)DBRoute.basedata, (String)QUERY_EXPIRE_AUTO_COMPENSATE_SQL, rs -> {
                while (rs.next()) {
                    String xid = rs.getString("fxid");
                    long seq = rs.getLong("fseq");
                    HashMap<String, String> xidSeq = new HashMap<String, String>();
                    xidSeq.put("xid", xid);
                    xidSeq.put("seq", seq + "");
                    toBeCompensates.add(xidSeq);
                    xids.add(xid);
                    if (toBeCompensates.size() <= 1000) continue;
                    break;
                }
                return null;
            });
            try {
                TcContext.getOrCreate().setAutoManuallyRetry(true);
                this.compensateService.manuallyRetry(toBeCompensates);
            }
            finally {
                this.deleteAutoCompensatedExpireDate(xids);
            }
        }
    }

    private void deleteAutoCompensatedExpireDate(List xids) {
        if (xids != null && xids.size() > 0) {
            SqlBuilder deleteSql = new SqlBuilder();
            deleteSql.append("delete from t_cbs_dtx_retry_schedule where fschedule_time <= now() and ", new Object[0]);
            deleteSql.appendIn("fxid", xids);
            DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)deleteSql);
        }
    }
}

