/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.kdtx.common.constant.GlobalTxStatus;
import kd.bos.kdtx.server.state.AccountInfo;
import kd.bos.kdtx.server.state.BaseTcState;
import kd.bos.kdtx.server.tasks.AbstractReportTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;

public class ReportCommittingTask
extends AbstractReportTask {
    private static final Log logger = LogFactory.getLog(ReportCommittingTask.class);

    @Override
    public void run() {
        try {
            ThreadLifeCycleManager.start();
            ConcurrentHashMap<String, AccountInfo> committingMap = BaseTcState.getCommittingMap();
            if (committingMap == null || committingMap.size() == 0) {
                return;
            }
            ConcurrentHashMap<String, AccountInfo> reportMap = new ConcurrentHashMap<String, AccountInfo>();
            reportMap.putAll(committingMap);
            this.report(reportMap, GlobalTxStatus.COMMITTING);
        }
        catch (Exception e) {
            logger.error("ReportCommittingTask error.", (Throwable)e);
        }
    }
}

