/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks;

import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.entity.TxInfoExtra;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.server.async.ActionAsyncServiceImpl;
import kd.bos.kdtx.server.async.AsyncServiceImpl;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.monitor.alarm.AlarmUtils;
import kd.bos.kdtx.server.service.impl.TransCoordinatorServiceImpl;
import kd.bos.kdtx.server.tasks.template.StatusTemplate;

public class RollbackTask
extends StatusTemplate {
    private static final String THREAD_NAME = "RollbackTask-Thread";
    private static final String LOCK_KEY = "kdtx.rollback-task";

    public RollbackTask() {
        super.setThreadName(THREAD_NAME);
        super.setLockKey(LOCK_KEY);
        this.setSql();
    }

    @Override
    protected final void setSql() {
        this.selectSql = "SELECT trs.fid as trs_fid, trs.fxid as fxid, trs.ftx_type as ftx_type, trs.ftenant_id as ftenant_id, trs.faccount_id as faccount_id, trs.fcreate_time as fcreate_time, trs.fupdate_time as fupdate_time, trs.froutekey as froutekey, trs.fserializer as fserializer, trs.fcontext as fcontext, rs.fid as rs_fid, ISNULL(rs.fcommit_retry_count, 0) as commit_retry_count, ISNULL(rs.frollback_retry_count, 0) as rollback_retry_count FROM t_cbs_dtx_transaction trs LEFT JOIN t_cbs_dtx_retry_stat rs on rs.fxid = trs.fxid and rs.ftrigger_type = 3 WHERE trs.fstatus in (3, 6) and (DATEADD(now(), -" + TransCoordinatorConfig.getTaskRollbackTimeout() + ") > trs.fupdate_time or rs.frollback_retry_count > 0) and (rs.frollback_retry_count is null or rs.frollback_retry_count < " + TransCoordinatorConfig.getTaskRollbackRetryMax() + ") and not exists (select 1 from t_cbs_dtx_retry_stat rs2 where  rs2.fxid=trs.fxid and rs2.ftrigger_type=2)";
    }

    @Override
    protected void recordRetryInfo(TxInfo txDo) {
        String insert_task_rollback_retry = "INSERT INTO t_cbs_dtx_retry_stat(fid, fxid, ftrigger_type, fcommit_retry_count, frollback_retry_count, fcreate_time, fupdate_time) VALUES(?,?,?,?,?,now(),now())";
        String update_rollback_retry_state = "UPDATE t_cbs_dtx_retry_stat SET frollback_retry_count = frollback_retry_count + 1, fupdate_time = NOW() WHERE fid = ?";
        long retryStatId = ((TxInfoExtra)txDo).getRetryStatId();
        String xid = txDo.getFxid();
        try (TXHandle tx = TX.requiresNew();){
            try {
                boolean ret;
                if (retryStatId == 0L) {
                    ret = DB.execute((DBRoute)DBRoute.base, (String)insert_task_rollback_retry, (Object[])new Object[]{ID.genLongId(), xid, 3, 0, 1});
                    if (!ret) {
                        throw new KdtxException("insertRetryLog error");
                    }
                } else {
                    ret = DB.execute((DBRoute)DBRoute.base, (String)update_rollback_retry_state, (Object[])new Object[]{retryStatId});
                    if (!ret) {
                        throw new KdtxException("execute update db error.");
                    }
                }
                if (((TxInfoExtra)txDo).getRollbackRetryCount() + 1 >= TransCoordinatorConfig.getTaskRollbackRetryMax()) {
                    this.toManual(txDo.getFxid());
                }
            }
            catch (Exception e) {
                tx.markRollback();
            }
        }
    }

    @Override
    protected void doJob(TxInfo txInfo) {
        TcContext.getOrCreate().setXid(txInfo.getFxid());
        TransCoordinatorServiceImpl transCoordinatorService = new TransCoordinatorServiceImpl();
        try {
            TcContext.getOrCreate().setTaskRetry(true);
            transCoordinatorService.proxyHandleTx(ActionType.TX_ROLLBACK, null);
        }
        catch (Exception e) {
            this.warn(txInfo);
            ExceptionLogger.error(RollbackTask.class, (String)"handleKdtx commit error", (Throwable)e);
        }
    }

    @Override
    protected void warn(TxInfo txDo) {
        if (((TxInfoExtra)txDo).getRollbackRetryCount() + 1 >= TransCoordinatorConfig.getTaskRollbackRetryMax()) {
            Map<String, String> sceneInfo = this.getSceneInfo(txDo.getFxid());
            if (TransCoordinatorConfig.isStandardThreadPool()) {
                AsyncServiceImpl.executeTask(() -> AlarmUtils.sendWarnMessage(txDo.getFxid(), (String)sceneInfo.get("name"), "ROLLBACK"));
            } else {
                ActionAsyncServiceImpl.asyncExecute(() -> AlarmUtils.sendWarnMessage(txDo.getFxid(), (String)sceneInfo.get("name"), "ROLLBACK"));
            }
        }
    }
}

