/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks.template;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.server.config.TransCoordinatorConfig;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;

public abstract class LockTemplate
implements Runnable {
    private RequestContext context = null;
    private String threadName;
    private String lockKey;
    private String lockId;
    private static final String NXXX = "NX";
    private static final String EXPX = "EX";
    private static final String SET_SUCCESS = "OK";
    private static final String REDIS_REGION = "kdtx";

    protected void setLockKey(String key) {
        this.lockKey = key;
    }

    protected void setThreadName(String name) {
        this.threadName = name;
    }

    protected abstract void execute();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(this.threadName);
        if (StringUtils.isEmpty((String)this.lockKey)) {
            ExceptionLogger.error(LockTemplate.class, (String)"lockKey is null. task ");
            return;
        }
        boolean ret = this.lock();
        try {
            List accounts;
            if (!ret) {
                return;
            }
            try {
                accounts = AccountUtils.getAllAccountsOfCurrentEnv();
            }
            catch (Exception e) {
                if (ret) {
                    this.unLock();
                }
                return;
            }
            accounts.forEach(account -> {
                ThreadLifeCycleManager.start();
                try {
                    this.context = RequestContext.create();
                    this.context.setAccountId(account.getAccountId());
                    this.context.setTenantId(account.getTenantId());
                    this.context.setTraceId(this.getTraceId());
                    String selectSql = "SELECT TOP 1 fid FROM t_cbs_dtx_transaction";
                    try {
                        DataSet ds = DB.queryDataSet((String)"LockTemplate", (DBRoute)DBRoute.base, (String)selectSql, null);
                        Throwable throwable = null;
                        if (ds != null) {
                            if (throwable != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        ExceptionLogger.info(LockTemplate.class, (String)"check table t_cbs_dtx_transaction error", (Object[])new Object[]{e});
                        this.context = null;
                        return;
                    }
                    this.execute();
                }
                finally {
                    this.context = null;
                }
            });
        }
        catch (Exception e) {
            ExceptionLogger.error(LockTemplate.class, (String)"task lock error.", (Throwable)e);
        }
        finally {
            if (ret) {
                this.unLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lock() {
        this.generateLockId();
        try (JedisClient jedis = this.getJedisClient();){
            String ret = jedis.set(this.lockKey, this.lockId, NXXX, EXPX, (long)TransCoordinatorConfig.getTaskLockTimeout());
            if (SET_SUCCESS.equals(ret)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLock() {
        String lua = "if redis.call('get',KEYS[1]) == ARGV[1] then return redis.call('del',KEYS[1]) else return 0 end";
        long ret = 0L;
        try (JedisClient jedis = this.getJedisClient();){
            ret = (Long)jedis.eval(lua, 1, new String[]{this.lockKey, this.lockId});
        }
        if (ret == 0L) {
            ExceptionLogger.warn(LockTemplate.class, (String)"unlock failed.");
        }
    }

    private JedisClient getJedisClient() {
        return RedisFactory.getJedisClient((String)this.getRedisUrl());
    }

    private String getRedisUrl() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)REDIS_REGION);
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        return url;
    }

    private void generateLockId() {
        String hostName = "hostname";
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostName = ia.getHostName();
        }
        catch (UnknownHostException e) {
            ExceptionLogger.error(LockTemplate.class, (String)"InetAddress getLocalHost error.", (Throwable)e);
        }
        String uuid = UUID.randomUUID().toString();
        String lockIdTmp = "";
        lockIdTmp = lockIdTmp + hostName;
        lockIdTmp = lockIdTmp + '-';
        this.lockId = lockIdTmp = lockIdTmp + uuid;
    }

    private String getTraceId() {
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        if (traceId == null || traceId.length() == 0) {
            traceId = TraceIdUtil.createTraceIdString();
        }
        return traceId;
    }
}

