/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.server.tasks.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.kdtx.common.entity.TempContextInfo;
import kd.bos.kdtx.common.entity.TxInfo;
import kd.bos.kdtx.common.entity.TxInfoExtra;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.server.context.TcContext;
import kd.bos.kdtx.server.tasks.homeless.CompensateStrategyScheduler;
import kd.bos.kdtx.server.tasks.template.LockTemplate;
import kd.bos.util.StringUtils;

public abstract class StatusTemplate
extends LockTemplate {
    protected String selectSql = "";
    protected String lockKey = "";
    private String lockId = "";
    public static final String PROJECT_NAME = "bos-kdtx-server";
    private static final CompensateStrategyScheduler compensateStrategyScheduler = new CompensateStrategyScheduler();
    protected static final String SQL_PREFIX = "SELECT trs.fid as trs_fid, trs.fxid as fxid, trs.ftx_type as ftx_type, trs.ftenant_id as ftenant_id, trs.faccount_id as faccount_id, trs.fcreate_time as fcreate_time, trs.fupdate_time as fupdate_time, trs.froutekey as froutekey, trs.fserializer as fserializer, trs.fcontext as fcontext, rs.fid as rs_fid, ISNULL(rs.fcommit_retry_count, 0) as commit_retry_count, ISNULL(rs.frollback_retry_count, 0) as rollback_retry_count FROM t_cbs_dtx_transaction trs LEFT JOIN t_cbs_dtx_retry_stat rs on rs.fxid = trs.fxid and rs.ftrigger_type = 3 WHERE ";
    private static final String SQL_SCENE_INFO = "select ts.fphone,ts.fname,tc.froutekey,ts.fcode,tc.fmodel from t_cbs_dtx_transaction  tc left join t_cbs_dtx_tx_scenes  ts on tc.fscenes_tx_id=ts.fid where tc.fxid=?";
    private static final String SQL_TO_MANUAL = "INSERT INTO t_cbs_dtx_RETRY_STAT( FID,FXID,FTRIGGER_TYPE,FCOMMIT_RETRY_COUNT,FROLLBACK_RETRY_COUNT,fseq,FCREATE_TIME,FUPDATE_TIME) VALUES(?,?,2,0,0,-1,NOW(),NOW())";

    @Override
    public void execute() {
        ArrayList<TxInfoExtra> txDOList = new ArrayList<TxInfoExtra>();
        try (DataSet ds = DB.queryDataSet((String)"StatusTemplate", (DBRoute)DBRoute.base, (String)this.selectSql, null);){
            for (Row row : ds) {
                TxInfoExtra txInfo = new TxInfoExtra();
                txInfo.setFid(row.getLong("trs_fid").longValue());
                txInfo.setFxid(row.getString("fxid"));
                txInfo.setFtenantId(row.getString("ftenant_id"));
                txInfo.setFaccountId(row.getLong("faccount_id").longValue());
                txInfo.setFcreateTime(row.getDate("fcreate_time"));
                txInfo.setFupdateTime(row.getDate("fupdate_time"));
                txInfo.setRetryStatId(row.getLong("rs_fid").longValue());
                txInfo.setCommitRetryCount(row.getInteger("commit_retry_count").intValue());
                txInfo.setRollbackRetryCount(row.getInteger("rollback_retry_count").intValue());
                txInfo.setFtxType(row.getInteger("ftx_type").intValue());
                txInfo.setRouteKey(row.getString("froutekey"));
                txInfo.setSerializer(row.getString("fserializer"));
                txInfo.setTempContextInfo(this.convertContextInfo(row.getString("fcontext")));
                txDOList.add(txInfo);
            }
        }
        catch (Exception e) {
            ExceptionLogger.error(StatusTemplate.class, (String)"SELECT t_cbs_dtx_transaction error", (Throwable)e);
            return;
        }
        txDOList.forEach(txDO -> {
            try {
                this.recordRetryInfo((TxInfo)txDO);
                KdtxRequestContext.get().setXid(txDO.getFxid());
                this.setRequestContext(txDO.getTempContextInfo());
                this.doJob((TxInfo)txDO);
            }
            catch (Exception e) {
                ExceptionLogger.error(StatusTemplate.class, (String)"execute job error.", (Throwable)e);
            }
            finally {
                KdtxRequestContext.set(null);
                TcContext.set(null);
            }
        });
    }

    protected abstract void setSql();

    protected abstract void recordRetryInfo(TxInfo var1);

    protected abstract void doJob(TxInfo var1);

    protected abstract void warn(TxInfo var1);

    protected Map<String, String> getSceneInfo(String xid) {
        HashMap<String, String> map = new HashMap<String, String>();
        try (DataSet ds = DB.queryDataSet((String)"StatusTemplate", (DBRoute)DBRoute.base, (String)SQL_SCENE_INFO, (Object[])new Object[]{xid});){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                map.put("phone", row.getString("fphone"));
                map.put("name", row.getString("fname"));
                map.put("routeKey", row.getString("froutekey"));
                map.put("txCode", row.getString("fcode"));
                map.put("model", row.getString("fmodel"));
            }
        }
        return map;
    }

    private TempContextInfo convertContextInfo(String contextStr) {
        if (StringUtils.isEmpty((String)contextStr)) {
            return null;
        }
        return (TempContextInfo)JsonUtils.parseJson((String)contextStr, TempContextInfo.class);
    }

    protected void toManual(String xid) {
        Object[] params = new Object[]{ID.genLongId(), xid};
        DB.execute((DBRoute)DBRoute.base, (String)SQL_TO_MANUAL, (Object[])params);
        compensateStrategyScheduler.joinAutoCompensate(xid);
    }

    private void setRequestContext(TempContextInfo tempContextInfo) {
        if (tempContextInfo == null) {
            return;
        }
        if (RequestContext.get() != null && StringUtils.isEmpty((String)RequestContext.get().getUserId())) {
            RequestContext.get().setUserId(String.valueOf(tempContextInfo.getUserId()));
            RequestContext.get().setUserName(tempContextInfo.getUserName());
        }
    }
}

