/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.invoke;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.manage.MServiceMetaManage;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.service.InvokeService;
import kd.bos.service.invoke.MServiceFactory;
import kd.bos.service.invoke.MserviceJacksonSerialize;
import kd.bos.util.JSONUtils;

public class InvokeServiceImpl
implements InvokeService {
    private static final Log log = LogFactory.getLog(InvokeServiceImpl.class);

    @Override
    public Object invoke(String serviceName, String methodName, Object ... paras) {
        try {
            Object serviceObject = MServiceFactory.getService(serviceName);
            Method mehtod = MServiceFactory.findServiceMethod(serviceObject.getClass(), methodName, paras == null ? 0 : paras.length);
            return mehtod.invoke(serviceObject, paras);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.error("InvokeService.invoke: " + serviceName + "." + methodName + ",parameters: " + paras, e);
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    @Override
    public Object invokeWithJson(String serviceName, String methodName, String jsonStr) {
        try {
            Object[] parameters = this.parseJsonParam(serviceName, methodName, jsonStr);
            Object serviceObject = MServiceFactory.getService(serviceName);
            Method mehtod = MServiceFactory.findServiceMethod(serviceObject.getClass(), methodName, parameters == null ? 0 : parameters.length);
            return mehtod.invoke(serviceObject, parameters);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            log.error("InvokeService.invokeJsonData: " + serviceName + "." + methodName + ",parameters: " + jsonStr, e);
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            throw new KDException(e, BosErrorCode.bOS, new Object[0]);
        }
    }

    private Object[] parseJsonParam(String serviceName, String methodName, String jsonStr) throws IOException {
        Map parameterMap = null == jsonStr ? null : (Map)JSONUtils.cast((String)jsonStr, HashMap.class);
        return this.getObjectParameters(serviceName, methodName, parameterMap, jsonStr);
    }

    private Object[] getObjectParameters(String serviceName, String methodName, Map<String, Object> parameterMap, String jsonStr) {
        if (parameterMap == null) {
            return null;
        }
        int paramSize = parameterMap.size();
        Object[] params = new Object[paramSize];
        ArrayList<MServiceDefineMeta.MethodDefine> theSameMethodDefineList = new ArrayList<MServiceDefineMeta.MethodDefine>(1);
        MServiceDefineMeta serviceDef = MServiceMetaManage.getServiceDefine((String)serviceName);
        List methodDefineList = serviceDef.getMethods();
        for (MServiceDefineMeta.MethodDefine methodDefine : methodDefineList) {
            if (!methodDefine.getServiceMethodName().equals(methodName)) continue;
            theSameMethodDefineList.add(methodDefine);
        }
        if (theSameMethodDefineList.size() == 0) {
            log.error("InvokeService.invokeJsonData not find method {}.{}", (Object)serviceName, (Object)methodName);
            throw new KDException(new ErrorCode("###", "not find method %s.%s"), new Object[]{serviceName, methodName});
        }
        for (MServiceDefineMeta.MethodDefine methodDefine : theSameMethodDefineList) {
            List paramDefines = methodDefine.getServiceMethodParams();
            for (int i = 0; i < paramDefines.size(); ++i) {
                Class<?> targetClass;
                MServiceDefineMeta.ParamDefine paramDefine = (MServiceDefineMeta.ParamDefine)paramDefines.get(i);
                Object object = parameterMap.get(paramDefine.getName());
                String typeStr = paramDefine.getTypeStr();
                if (paramDefine.isPrimitive()) {
                    params[i] = this.convertToPrimitive(object, typeStr);
                    continue;
                }
                try {
                    targetClass = Class.forName(typeStr);
                }
                catch (ClassNotFoundException e) {
                    log.error("InvokeService.invokeJsonData class {} not find", (Object)typeStr);
                    throw new KDException(new ErrorCode("###", "class %s not find"), new Object[]{typeStr});
                }
                if (targetClass.isInstance(object)) {
                    params[i] = object;
                    continue;
                }
                try {
                    params[i] = MserviceJacksonSerialize.convertValue(object, targetClass);
                    continue;
                }
                catch (Exception e) {
                    log.error("Parameter type mismatch,The parameters provided are {},The actual parameter type are {}", (Object)jsonStr, (Object)typeStr);
                    throw new KDException((Throwable)e, new ErrorCode("###", "Parameter type mismatch,The parameters provided are %s,The actual parameter are %s"), new Object[]{serviceName, jsonStr});
                }
            }
        }
        return params;
    }

    private Object convertToPrimitive(Object value, String typeName) {
        if (this.isPrimitiveOrWrapper(value.getClass())) {
            return value;
        }
        try {
            Class toType = null;
            switch (typeName) {
                case "int": {
                    toType = Integer.class;
                    break;
                }
                case "long": {
                    toType = Long.class;
                    break;
                }
                case "float": {
                    toType = Float.class;
                    break;
                }
                case "double": {
                    toType = Double.class;
                    break;
                }
                case "byte": {
                    toType = Byte.class;
                    break;
                }
                case "short": {
                    toType = Short.class;
                    break;
                }
                case "char": {
                    toType = Character.class;
                    break;
                }
                case "boolean": {
                    toType = Boolean.class;
                    break;
                }
                default: {
                    return null;
                }
            }
            Method valueOfMethod = toType.getMethod("valueOf", String.class);
            return valueOfMethod.invoke(null, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("InvokeService.convertToPrimitive value {} Cannot convert to {}", value, (Object)typeName);
            throw new KDException(new ErrorCode("###", "InvokeService.convertToPrimitive value {} Cannot convert to {}"), new Object[]{value, typeName});
        }
    }

    private boolean isPrimitiveOrWrapper(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        return type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Long.class) || type.isAssignableFrom(Float.class) || type.isAssignableFrom(Double.class) || type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Short.class) || type.isAssignableFrom(Character.class) || type.isAssignableFrom(Boolean.class);
    }
}

