/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.invoke;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class MserviceJacksonSerialize {
    public static final Charset UTF_8;
    private static final ObjectMapper mapper;
    private static final Date ZERO;

    public static Object convertValue(Object fromValue, Class toValueType) throws IllegalArgumentException {
        return mapper.convertValue(fromValue, toValueType);
    }

    public static Object readValue(String fromValue, Class toValueType) throws JsonProcessingException {
        return mapper.readValue(fromValue, toValueType);
    }

    public static String writeValueAsString(Object value) throws JsonProcessingException {
        return mapper.writeValueAsString(value);
    }

    static {
        mapper = new ObjectMapper();
        UTF_8 = StandardCharsets.UTF_8;
        ZERO = CustomDateDeserializer.t("1899-12-30");
        SimpleModule simpleModule = new SimpleModule();
        mapper.registerModule((Module)simpleModule.addDeserializer(Date.class, (JsonDeserializer)CustomDateDeserializer.instance));
        mapper.registerModule((Module)new JavaTimeModule());
    }

    public static class CustomDateDeserializer
    extends JsonDeserializer<Date> {
        public static final CustomDateDeserializer instance = new CustomDateDeserializer();

        private static Timestamp t(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            if (value instanceof Date) {
                return new Timestamp(((Date)value).getTime());
            }
            if (value instanceof Long) {
                return new Timestamp((Long)value);
            }
            if (value instanceof Double) {
                double t = (Double)value * 8.64E7;
                return new Timestamp((long)t + ZERO.getTime());
            }
            String s0 = value.toString();
            if (s0 == null) {
                return null;
            }
            String s = s0.trim();
            if (s.length() == 0) {
                return null;
            }
            if (CustomDateDeserializer.isLong(s)) {
                return new Timestamp(Long.parseLong(s));
            }
            String format = CustomDateDeserializer.getDateFormat(s);
            s = CustomDateDeserializer.adjustDateString(s, format);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(s, formatter);
                return Timestamp.valueOf(localDateTime);
            }
            catch (Exception var7) {
                LocalDate localDate = LocalDate.parse(s, formatter);
                return CustomDateDeserializer.toTimestamp(localDate);
            }
        }

        private static Timestamp toTimestamp(LocalDate localDate) {
            if (localDate == null) {
                return null;
            }
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime zonedDateTime = localDate.atStartOfDay(zoneId);
            Date date = Date.from(zonedDateTime.toInstant());
            return new Timestamp(date.getTime());
        }

        private static Timestamp toTimestamp(LocalDateTime localDateTime) {
            return localDateTime == null ? null : Timestamp.valueOf(localDateTime);
        }

        private static String getDateFormat(String s) {
            String format = null;
            if (s.indexOf(84) > 0) {
                format = s.indexOf(46) > 0 ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : "yyyy-MM-dd'T'HH:mm:ss";
            } else if (s.indexOf(32) > 0) {
                if (s.indexOf(45) > 0) {
                    format = s.indexOf(46) > 0 ? "yyyy-MM-dd HH:mm:ss.SSS" : "yyyy-MM-dd HH:mm:ss";
                } else if (s.indexOf(47) > 0) {
                    format = s.indexOf(46) > 0 ? "yyyy/MM/dd HH:mm:ss.SSS" : "yyyy/MM/dd HH:mm:ss";
                }
            } else if (s.indexOf(47) > 0) {
                format = "yyyy/MM/dd";
            } else if (s.indexOf(45) > 0) {
                format = "yyyy-MM-dd";
            } else if (s.indexOf(58) > 0) {
                format = s.indexOf(46) > 0 ? "HH:mm:ss.SSS" : "HH:mm:ss";
            }
            if (format != null) {
                return format;
            }
            throw new KDException(BosErrorCode.bOS, new Object[]{"illegal datetime format, s='" + s + "'.", new Object[0]});
        }

        private static String adjustDateString(String s, String format) {
            int i;
            if (format.endsWith(".SSS") && (i = s.length() - s.lastIndexOf(46) - 1) < 3) {
                s = s + "000".substring(i);
            }
            return s;
        }

        private static boolean isLong(String d) {
            int j = d.length();
            for (int i = 0; i < j; ++i) {
                char c = d.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }

        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String dateString = jsonParser.getText();
            try {
                Timestamp timestamp = CustomDateDeserializer.t(dateString);
                if (timestamp == null) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"JsonParser getText() Cannot be empty"});
                }
                return new Date(timestamp.getTime());
            }
            catch (Exception exception) {
                throw new IOException("Failed to parse date: " + dateString);
            }
        }
    }
}

