/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.invoke.rpc;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.catalog.ServiceCatalogFactory;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.service.invoke.rpc.InvokeRequest;
import kd.bos.service.invoke.rpc.RpcInvoke;
import kd.bos.service.invoke.rpc.RpcInvokeBuilder;

public class InvokeServiceHelper {
    public static Object invoke(String appId, String interfacesName, String methodName, Object ... paras) {
        MServiceDefineMeta mServiceDefineMeta = ServiceCatalogFactory.getCatalogCenter().getMServiceDefineMeta(interfacesName);
        if (mServiceDefineMeta == null) {
            throw new KDException(BosErrorCode.paramError, new Object[]{interfacesName + " not defined on the server side"});
        }
        InvokeRequest ir = new InvokeRequest().withRequestAppid(appId).withServiceName(mServiceDefineMeta.getServiceName()).withServiceMethod(methodName).withParams(paras);
        RpcInvoke rpcInvoke = new RpcInvokeBuilder().withTransprotocolType("rpc").build();
        Object object = rpcInvoke.request(ir);
        return object;
    }

    public static Object invokeJsonData(String appId, String interfacesName, String methodName, String jsonStr) {
        MServiceDefineMeta mServiceDefineMeta = ServiceCatalogFactory.getCatalogCenter().getMServiceDefineMeta(interfacesName);
        if (mServiceDefineMeta == null) {
            throw new KDException(BosErrorCode.paramError, new Object[]{interfacesName + " not defined on the server side"});
        }
        InvokeRequest ir = new InvokeRequest().withRequestAppid(appId).withServiceName(mServiceDefineMeta.getServiceName()).withServiceMethod(methodName).withParams(jsonStr);
        RpcInvoke rpcInvoke = new RpcInvokeBuilder().withTransprotocolType("rpc").build();
        return rpcInvoke.requestWithJson(ir);
    }
}

