/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.invoke.rpc;

import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.mservice.MServiceErrorCode;
import kd.bos.service.InvokeService;
import kd.bos.service.invoke.rpc.InvokeRequest;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.trace.util.TraceIdUtil;

public class RpcInvoke {
    private final String codecType;
    private final String transprotocolType;

    public RpcInvoke(String transprotocolType, String codecType) {
        this.codecType = codecType;
        this.transprotocolType = transprotocolType;
    }

    public Object request(InvokeRequest request) {
        try {
            request.resetParams();
            RequestContext rc = RequestContext.getOrCreate();
            if (rc.getTraceId() == null) {
                rc.setTraceId(TraceIdUtil.createTraceIdString());
            }
            String serviceAppId = ServiceLookup.getServiceAppId((String)request.getRequestAppid());
            InvokeService service = "http".equals(this.transprotocolType) ? (InvokeService)ServiceLookup.lookupHttp(InvokeService.class, (String)serviceAppId, (String)this.codecType) : (InvokeService)ServiceLookup.lookup(InvokeService.class, (String)serviceAppId);
            Object returnObj = service.invoke(request.getServiceName(), request.getServiceMethod(), request.getParams());
            return returnObj;
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            throw new KDException(MServiceErrorCode.serviceInvokeError, "invoke error : for " + this.transprotocolType + " codec by " + this.codecType, (Throwable)e);
        }
    }

    public Object requestWithJson(InvokeRequest request) {
        try {
            request.resetParams();
            RequestContext rc = RequestContext.getOrCreate();
            if (rc.getTraceId() == null) {
                rc.setTraceId(TraceIdUtil.createTraceIdString());
            }
            String serviceAppId = ServiceLookup.getServiceAppId((String)request.getRequestAppid());
            InvokeService service = (InvokeService)ServiceLookup.lookup(InvokeService.class, (String)serviceAppId);
            Object[] params = request.getParams();
            String jsonStrParam = params != null && params.length > 0 ? (String)params[0] : null;
            return service.invokeWithJson(request.getServiceName(), request.getServiceMethod(), jsonStrParam);
        }
        catch (Exception e) {
            if (e instanceof KDException) {
                throw (KDException)e;
            }
            throw new KDException(MServiceErrorCode.serviceInvokeError, "RpcInvoke requestJsonData error : for " + this.transprotocolType + " codec by " + this.codecType, (Throwable)e);
        }
    }
}

