/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import javax.sql.DataSource;
import kd.bos.config.client.util.ConfigUtils;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.center.common.DBCongfigTypeEnum;
import kd.bos.mservice.center.common.DataSourceFactory;
import kd.bos.mservice.center.common.ResultHandler;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.ParameterSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUtil {
    private static Map<String, DataSource> dataSources = new ConcurrentHashMap<String, DataSource>(2);
    private static Map<String, AtomicBoolean> initFlags = new ConcurrentHashMap<String, AtomicBoolean>(2);
    private static final Logger logger = LoggerFactory.getLogger(DBUtil.class);

    public static void initDataSouce(DBCongfigTypeEnum type, boolean fromProperty, String url) {
        block17: {
            AtomicBoolean aBoolean = initFlags.computeIfAbsent(type.getConfigKey(), v -> new AtomicBoolean());
            if (aBoolean.compareAndSet(false, true)) {
                try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
                    dataSources.computeIfAbsent(type.getConfigKey(), v -> {
                        if (fromProperty) {
                            if (url != null && url.trim().length() > 0) {
                                return DataSourceFactory.createDataSourceFromUrl(url);
                            }
                            return DataSourceFactory.createDataSourceFromProperty(type.getConfigKey());
                        }
                        return DataSourceFactory.createDataSourceFromMCAPI();
                    });
                    break block17;
                }
                catch (Throwable e) {
                    aBoolean.compareAndSet(true, false);
                    logger.error("init dataSource error", e);
                    if (e instanceof KDException) {
                        throw (KDException)e;
                    }
                    throw new KDException(BosErrorCode.bOS, new Object[]{e});
                }
            }
            for (int count = 0; !dataSources.containsKey(type.getConfigKey()) && count < 20; ++count) {
                LockSupport.parkNanos(100000000L);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean execute(DBCongfigTypeEnum type, String sql, Object[] params) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean executeBatch(DBCongfigTypeEnum type, String sql, List<Object[]> paramList) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean executeMultiSqlBatch(DBCongfigTypeEnum type, List<Tuple<String, List<Object[]>>> sqlAndParams) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean executeMultiSql(DBCongfigTypeEnum type, List<Tuple<String, Object[]>> sqlAndParams) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T query(DBCongfigTypeEnum type, String sql, Object[] params, ResultHandler handler) throws Exception {
        if (handler == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"ResultHandler must be not null!!!"});
        }
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            Connection connection = DBUtil.getDataSource(type).getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ParameterSetter.set((PreparedStatement)preparedStatement, (Object)params[i], (int)(i + 1));
                }
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            Object t = handler.handle(resultSet, connection, preparedStatement);
            return t;
        }
    }

    private static void close(Connection connection, PreparedStatement[] preparedStatements) {
        if (preparedStatements != null) {
            for (PreparedStatement preparedStatement : preparedStatements) {
                if (preparedStatement == null) continue;
                try {
                    preparedStatement.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static DataSource getDataSource(DBCongfigTypeEnum type) {
        DataSource dataSource = dataSources.get(type.getConfigKey());
        if (dataSource == null) {
            String property;
            boolean fromProperty = true;
            if (type == DBCongfigTypeEnum.DBCONFIG && (property = ConfigUtils.getConfigUrlType()) != null && "mc".equals(property.toLowerCase(Locale.ENGLISH))) {
                fromProperty = false;
            }
            DBUtil.initDataSouce(type, fromProperty, null);
            dataSource = dataSources.get(type.getConfigKey());
        }
        return dataSource;
    }
}

