/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.common;

import com.alibaba.druid.filter.stat.StatFilterContext;
import com.alibaba.druid.filter.stat.StatFilterContextListener;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DBConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.trace.instrument.druid.DruidStatFilterContextListener;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataSourceInfoCreator {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceInfoCreator.class);
    private static final Map<String, String> dbcp_keymap = new HashMap<String, String>();
    private static final Map<String, String> druid_keymap = new HashMap<String, String>();
    private static final Map<String, String> hikari_keymap = new HashMap<String, String>();

    DataSourceInfoCreator() {
    }

    private static void transProperties(Properties defaultProps, String type) {
        if (defaultProps == null || defaultProps.isEmpty()) {
            return;
        }
        Map<String, String> keyMap = null;
        switch (type) {
            case "dbcp": {
                keyMap = dbcp_keymap;
                break;
            }
            case "druid": {
                keyMap = druid_keymap;
                break;
            }
            case "hikari": {
                keyMap = hikari_keymap;
                break;
            }
            default: {
                return;
            }
        }
        for (String oldKey : new HashSet<String>(keyMap.keySet())) {
            String newKey = keyMap.get(oldKey);
            if (newKey.equals(oldKey)) continue;
            if (newKey.length() == 0) {
                defaultProps.remove(oldKey);
                continue;
            }
            String value = defaultProps.getProperty(oldKey);
            if (value == null) continue;
            if (!defaultProps.containsKey(newKey)) {
                defaultProps.put(newKey, value);
            }
            defaultProps.remove(oldKey);
        }
    }

    static DataSource createDataSource(DBConfig dbInfo, Properties defaultProps, String type) {
        DataSourceInfoCreator.transProperties(defaultProps, type);
        switch (type) {
            case "dbcp": {
                return DataSourceInfoCreator.createDBCPDataSource(dbInfo, defaultProps);
            }
            case "druid": {
                if (defaultProps != null) {
                    if (defaultProps.containsKey("maxTotal")) {
                        defaultProps.setProperty("maxActive", defaultProps.getProperty("maxTotal"));
                    } else if (defaultProps.containsKey("maxActive")) {
                        defaultProps.setProperty("maxTotal", defaultProps.getProperty("maxActive"));
                    }
                }
                return DataSourceInfoCreator.createDruidDataSource(dbInfo, defaultProps);
            }
        }
        return DataSourceInfoCreator.createHikariDataSource(dbInfo, defaultProps);
    }

    private static DataSource createHikariDataSource(DBConfig dbInfo, Properties defaultProps) {
        try {
            Properties props = new Properties();
            if (defaultProps != null) {
                props.putAll((Map<?, ?>)defaultProps);
            }
            props.putAll((Map<?, ?>)dbInfo.getDefaultProperties());
            HikariConfig config = new HikariConfig();
            long idleTimeout = TimeUnit.MINUTES.toMillis(10L);
            long validationTimeout = TimeUnit.SECONDS.toMillis(10L);
            long maxLifetime = 0L;
            config.setConnectionTimeout((long)dbInfo.getPoolMaxWait());
            config.setMinimumIdle(dbInfo.getPoolMinIdle());
            config.setMaximumPoolSize(dbInfo.getPoolMaxActive());
            config.setIdleTimeout(idleTimeout);
            config.setValidationTimeout(validationTimeout);
            config.setMaxLifetime(0L);
            try {
                if (defaultProps != null) {
                    if (defaultProps.containsKey("connectionTimeout")) {
                        config.setConnectionTimeout(Long.parseLong(defaultProps.getProperty("connectionTimeout")));
                    }
                    if (defaultProps.containsKey("minimumIdle")) {
                        config.setMinimumIdle(Integer.parseInt(defaultProps.getProperty("minimumIdle")));
                    }
                    if (defaultProps.containsKey("maximumPoolSize")) {
                        config.setMaximumPoolSize(Integer.parseInt(defaultProps.getProperty("maximumPoolSize")));
                    }
                    if (defaultProps.containsKey("idleTimeout")) {
                        config.setIdleTimeout(Long.parseLong(defaultProps.getProperty("idleTimeout")));
                    }
                    if (defaultProps.containsKey("validationTimeout")) {
                        config.setValidationTimeout(Long.parseLong(defaultProps.getProperty("validationTimeout")));
                    }
                    if (defaultProps.containsKey("maxLifetime")) {
                        config.setMaxLifetime(Long.parseLong(defaultProps.getProperty("maxLifetime")));
                    }
                }
            }
            catch (Throwable e) {
                String error = String.format("The config of datasource is incorrect,default config will be used. error_config=%s", defaultProps);
                logger.warn(error, e);
            }
            config.setDriverClassName(dbInfo.getDriver());
            config.setJdbcUrl(dbInfo.getUrl());
            config.setUsername(dbInfo.getUser());
            config.setPassword(dbInfo.getPassword());
            config.setConnectionTestQuery("SELECT 1");
            config.setPoolName("db-registry-center");
            config.setAutoCommit(true);
            return new HikariDataSource(config);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.dataSource, new Object[]{e.getMessage() + "\nurl=" + dbInfo.getUrl()});
        }
    }

    private static DataSource createDBCPDataSource(DBConfig dbInfo, Properties defaultProps) {
        try {
            Properties props = new Properties();
            props.setProperty("initialSize", String.valueOf(dbInfo.getPoolInitialSize()));
            props.setProperty("minIdle", String.valueOf(dbInfo.getPoolMinIdle()));
            props.setProperty("maxIdle", String.valueOf(dbInfo.getPoolMaxIdle()));
            props.setProperty("maxTotal", String.valueOf(dbInfo.getPoolMaxActive()));
            props.setProperty("maxWaitMillis", String.valueOf(dbInfo.getPoolMaxWait()));
            props.setProperty("removeAbandonedOnBorrow", Boolean.FALSE.toString());
            props.setProperty("removeAbandonedOnMaintenance", Boolean.FALSE.toString());
            if (defaultProps != null) {
                props.putAll((Map<?, ?>)defaultProps);
            }
            props.putAll((Map<?, ?>)dbInfo.getDefaultProperties());
            DataSourceInfoCreator.putConstants(dbInfo, props);
            props.setProperty("rollbackOnReturn", "false");
            props.setProperty("enableAutocommitOnReturn", "true");
            BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)props);
            ds.setJmxName("db-registry-center");
            ds.setDefaultAutoCommit(Boolean.TRUE);
            return ds;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.dataSource, new Object[]{e.getMessage()});
        }
    }

    private static DataSource createDruidDataSource(DBConfig dbInfo, Properties defaultProps) {
        try {
            Properties props = new Properties();
            props.setProperty("initialSize", String.valueOf(dbInfo.getPoolInitialSize()));
            props.setProperty("minIdle", String.valueOf(dbInfo.getPoolMinIdle()));
            props.setProperty("maxIdle", String.valueOf(dbInfo.getPoolMaxIdle()));
            props.setProperty("maxActive", String.valueOf(dbInfo.getPoolMaxActive()));
            props.setProperty("maxWait", String.valueOf(dbInfo.getPoolMaxWait()));
            if (defaultProps != null) {
                props.putAll((Map<?, ?>)defaultProps);
            }
            props.putAll((Map<?, ?>)dbInfo.getDefaultProperties());
            DataSourceInfoCreator.putConstants(dbInfo, props);
            DruidDataSource ds = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)props);
            ds.setName("db-registry-center");
            ds.setDefaultAutoCommit(true);
            ds.addFilters("stat");
            StatFilterContext.getInstance().addContextListener((StatFilterContextListener)new DruidStatFilterContextListener());
            return ds;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.dataSource, new Object[]{e.getMessage()});
        }
    }

    private static void putConstants(DBConfig dbInfo, Properties props) {
        if (props.getProperty("driverClassName") == null) {
            props.setProperty("driverClassName", dbInfo.getDriver());
        }
        props.setProperty("url", dbInfo.getUrl());
        props.setProperty("username", dbInfo.getUser());
        props.setProperty("password", dbInfo.getPassword());
        props.setProperty("defaultAutoCommit", "true");
        String validationQuery = "SELECT 1";
        if (dbInfo.getDBType() == DBType.Oracle || dbInfo.getDBType() == DBType.DM || dbInfo.getDBType() == DBType.YasDB) {
            validationQuery = validationQuery + " FROM DUAL";
        }
        props.setProperty("validationQuery", validationQuery);
        props.setProperty("testOnBorrow", "true");
        props.setProperty("testWhileIdle", "true");
        props.setProperty("timeBetweenEvictionRunsMillis", "600000");
        props.setProperty("timeBetweenConnectErrorMillis", "180000");
    }

    static {
        dbcp_keymap.put("initialSize", "initialSize");
        dbcp_keymap.put("maxTotal", "maxTotal");
        dbcp_keymap.put("maxIdle", "maxIdle");
        dbcp_keymap.put("minIdle", "minIdle");
        dbcp_keymap.put("maxWait", "maxWaitMillis");
        druid_keymap.put("initialSize", "initialSize");
        druid_keymap.put("maxTotal", "maxActive");
        druid_keymap.put("maxIdle", "maxIdle");
        druid_keymap.put("minIdle", "minIdle");
        druid_keymap.put("maxWait", "maxWait");
        hikari_keymap.put("initialSize", "");
        hikari_keymap.put("maxTotal", "maximumPoolSize");
        hikari_keymap.put("maxIdle", "");
        hikari_keymap.put("minIdle", "minimumIdle");
        hikari_keymap.put("maxWait", "connectionTimeout");
    }
}

