/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.config.db.task;

import java.util.List;
import kd.bos.instance.Instance;
import kd.bos.mservice.center.config.db.common.ConfigDTO;
import kd.bos.mservice.center.config.db.util.ConfigCacheHelper;
import kd.bos.mservice.center.config.db.util.ConfigDBHelper;
import kd.bos.mservice.center.config.db.util.DBConfigCenterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateConifgTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateConifgTask.class);
    private static final String THREAD_NAME = "UpdateConifgTask-Thread";
    private boolean deleted;
    private String clusterName;
    private List<String> configAppNames;
    private long count;

    public UpdateConifgTask(String clusterName) {
        this.clusterName = clusterName;
        try {
            this.configAppNames = ConfigDBHelper.queryConfigNames(clusterName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName(THREAD_NAME);
        try {
            boolean result;
            if (!this.deleted && (result = ConfigDBHelper.deleteStatusOfDeletedConfig(Instance.getClusterName()))) {
                this.deleted = true;
            }
            if (this.configAppNames == null || this.configAppNames.size() == 0 || this.count % 20L == 0L) {
                this.configAppNames = ConfigDBHelper.queryConfigNames(this.clusterName);
            }
            for (String appName : this.configAppNames) {
                if (ConfigCacheHelper.checkVersion(this.clusterName, appName)) continue;
                List<ConfigDTO> distriubuteConfigDTOS = ConfigCacheHelper.hgetConfig(this.clusterName, appName);
                if (distriubuteConfigDTOS != null && distriubuteConfigDTOS.size() > 0) {
                    List<ConfigDTO> localConfigs = ConfigCacheHelper.getConfigsFromLocal(this.clusterName, appName);
                    DBConfigCenterUtil.compareAndUpdate(distriubuteConfigDTOS, localConfigs, false, this.clusterName, appName);
                    return;
                }
                List<ConfigDTO> dbConfigDTOS = ConfigDBHelper.queryAllConfigs(this.clusterName, appName);
                if (dbConfigDTOS == null || dbConfigDTOS.size() <= 0) continue;
                List<ConfigDTO> localConfigs = ConfigCacheHelper.getConfigsFromLocal(this.clusterName, appName);
                DBConfigCenterUtil.compareAndUpdate(dbConfigDTOS, localConfigs, true, this.clusterName, appName);
            }
        }
        catch (Throwable e) {
            logger.error("execute UpdateConifgTask error", e);
        }
        ++this.count;
    }
}

