/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class DBRegistrant {
    private static Map<String, Set<String>> registyInfoMaps = new ConcurrentHashMap<String, Set<String>>(8);

    public static List<String> getRegistyInfo(String versionKey) {
        Set<String> urls = registyInfoMaps.get(versionKey);
        if (urls != null && urls.size() > 0) {
            return new ArrayList<String>(urls);
        }
        return Collections.EMPTY_LIST;
    }

    public static void updateAll(List<String> fullUrls, String serviceKey, String clusterName) {
        if (fullUrls != null && fullUrls.size() > 0) {
            String key = serviceKey + "&###&" + clusterName;
            Set tempList = registyInfoMaps.computeIfAbsent(key, k -> new CopyOnWriteArraySet());
            tempList.clear();
            tempList.addAll(fullUrls);
        }
    }
}

