/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.db.task;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mservice.center.common.MserviceCenterConstants;
import kd.bos.mservice.center.common.MserviceCenterUtil;
import kd.bos.mservice.center.common.ResultHandler;
import kd.bos.mservice.center.registry.db.DBSubscriber;
import kd.bos.mservice.center.registry.db.util.RegistryCacheHelper;
import kd.bos.mservice.center.registry.db.util.RegistryDBHelper;
import kd.bos.mservice.center.registry.db.util.RegistryUtil;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;

public class ProviderListManageTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ProviderListManageTask.class);
    private String clusterName = Instance.getClusterName();
    private static final String threadName = "ProviderListManageTask-Thread";
    private boolean hasDeleted;

    @Override
    public void run() {
        Thread.currentThread().setName(threadName);
        try {
            Set<String> versionKeys;
            if (!this.hasDeleted) {
                this.deleteRegistryInfo();
                this.hasDeleted = true;
            }
            if ((versionKeys = DBSubscriber.getSubscribKey()) != null && versionKeys.size() > 0) {
                for (String versionKey : versionKeys) {
                    String[] serviceKeyAndClusterName = versionKey.split("&###&");
                    if (RegistryCacheHelper.checkVersion(versionKey)) continue;
                    List<String> fullUrsl = RegistryCacheHelper.hgetUrls(versionKey);
                    if (fullUrsl != null && fullUrsl.size() > 0) {
                        Set<String> paths = RegistryCacheHelper.hgetPaths(versionKey);
                        RegistryUtil.updateLocalCache(serviceKeyAndClusterName[0], serviceKeyAndClusterName[1], fullUrsl, RegistryCacheHelper.hgetVersion(versionKey));
                        if (MserviceCenterUtil.isLogEnable()) {
                            logger.info("notifyChange-->versionKey:{},,urls:{}", (Object)versionKey, (Object)JSON.toJSONString(fullUrsl));
                        }
                        DBSubscriber.notifyChange(versionKey, fullUrsl, paths);
                        continue;
                    }
                    RegistryUtil.updateService(versionKey, serviceKeyAndClusterName[0], serviceKeyAndClusterName[1]);
                }
            }
        }
        catch (Throwable e) {
            logger.error("execute ProviderListManageTask error", e);
        }
    }

    private void deleteRegistryInfo() throws Exception {
        final Date deleteTime = DateUtils.plusSecondsWithDate((Date)new Date(), (int)(-MserviceCenterConstants.DEAD_TIME.intValue()));
        final HashSet<String> deleteInstanceIds = new HashSet<String>(8);
        final HashSet<Long> deleteIds = new HashSet<Long>(8);
        Set allInstanceIds = (Set)RegistryDBHelper.queryAllInstance(this.clusterName, new ResultHandler(){

            protected Set<String> doHandle(ResultSet resultSet) throws SQLException {
                HashSet<String> tempAllInstanceIds = new HashSet<String>(8);
                while (resultSet.next()) {
                    Long id = resultSet.getLong("FID");
                    String instanceId = resultSet.getString("FINSTANCEID");
                    Timestamp date = resultSet.getTimestamp("FLASTACTIVETIME");
                    if (date.before(deleteTime)) {
                        deleteInstanceIds.add(instanceId);
                        deleteIds.add(id);
                    }
                    tempAllInstanceIds.add(instanceId);
                }
                return tempAllInstanceIds;
            }
        });
        this.deleteExceed6HoursService(deleteInstanceIds, deleteIds);
        List<RegistrationInfo> registyInfos = RegistryDBHelper.queryRegistryInfoByInstanceId(null, this.clusterName);
        this.deleteServiceNotExistsInLivingInstance(deleteTime, allInstanceIds, registyInfos);
    }

    private void deleteExceed6HoursService(Set<String> deleteInstanceIds, Set<Long> deleteIds) {
        if (deleteInstanceIds.size() > 0) {
            try {
                RegistryDBHelper.deleteRegistryAndLivingInstance(deleteInstanceIds, deleteIds, this.clusterName);
            }
            catch (Throwable e) {
                logger.error("Delete registryinfo error.", e);
            }
        }
    }

    private void deleteServiceNotExistsInLivingInstance(Date deleteTime, Set<String> allInstanceIds, List<RegistrationInfo> registyInfos) {
        HashSet<String> needDelteServiceInstanceIds = new HashSet<String>(registyInfos.size());
        for (RegistrationInfo registyInfo : registyInfos) {
            if (!registyInfo.getUpdateTime().before(deleteTime) || allInstanceIds.contains(registyInfo.getInstanceId())) continue;
            needDelteServiceInstanceIds.add(registyInfo.getInstanceId());
        }
        if (!needDelteServiceInstanceIds.isEmpty()) {
            RegistryDBHelper.deleteRegistryInfo(needDelteServiceInstanceIds, this.clusterName);
        }
    }
}

