/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.db.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.mservice.center.common.DBCongfigTypeEnum;
import kd.bos.mservice.center.common.DBUtil;
import kd.bos.mservice.center.common.MserviceCenterConstants;
import kd.bos.mservice.center.common.MserviceCenterUtil;
import kd.bos.mservice.center.common.ResultHandler;
import kd.bos.mservice.center.registry.db.util.RegistryCacheHelper;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;

public class RegistryDBHelper {
    private static final Log logger = LogFactory.getLog(RegistryDBHelper.class);
    private static final String SAVE_SERVICE_SQL = "INSERT INTO T_CBS_RC_SERVICE(FID,FSERVICEIDENTITY,FSERVICEPATH,FFULLURL,FPADDRESS,FINSTANCEID,FCREATETIME,FUPDATETIME,FCLUSTERNAME,FCATEGORYPATH) VALUES(?,?,?,?,?,?,?,?,?,?)";
    private static final String DELETE_SERVICE_SQL = "DELETE FROM T_CBS_RC_SERVICE WHERE FSERVICEIDENTITY = ? AND FINSTANCEID = ? AND FCLUSTERNAME = ?";
    private static final String QUERY_SERVICE_SQL = "SELECT A.FFULLURL,A.FSERVICEIDENTITY,A.FINSTANCEID,B.FLASTACTIVETIME,A.FCATEGORYPATH  FROM T_CBS_RC_SERVICE A INNER JOIN T_CBS_LIVINGINSTANCE B ON A.FINSTANCEID=B.FINSTANCEID WHERE A.FSERVICEIDENTITY = ? AND A.FCLUSTERNAME = ?";
    private static final String QUERY_SERVICE_SQL1 = "SELECT A.FFULLURL,A.FSERVICEIDENTITY,A.FINSTANCEID,A.FUPDATETIME,A.FCLUSTERNAME FROM T_CBS_RC_SERVICE A ";
    private static final String SAVE_LIVINGINSTANCE_SQL = "INSERT INTO T_CBS_LIVINGINSTANCE(FID,FINSTANCEID,FCLUSTERNAME,FLASTACTIVETIME,FCREATETIME,FUPDATETIME) VALUES(?,?,?,NOW(),NOW(),NOW())";
    private static final String QUERY_LIVINGINSTANCE_SQL = "SELECT FID FROM T_CBS_LIVINGINSTANCE WHERE FINSTANCEID =? and FCLUSTERNAME = ?";
    private static final String QUERY_ALLLIVINGINSTANCE_SQL = "SELECT FID,FINSTANCEID, FLASTACTIVETIME FROM T_CBS_LIVINGINSTANCE WHERE FCLUSTERNAME = ?";
    private static final String UPDATE_LIVINGINSTANCE_SQL = "UPDATE T_CBS_LIVINGINSTANCE SET FLASTACTIVETIME = NOW() WHERE FID = ? ";
    private static final String DELETE_LIVINGINSTANCE_SQL = "DELETE FROM T_CBS_LIVINGINSTANCE";
    private static final String DELETE_SERVICE_SQL_PREFIX = "DELETE FROM T_CBS_RC_SERVICE";

    public static void saveRegistyInfo(RegistrationInfo registyInfo) {
        Object[] params = new Object[10];
        params[0] = ID.genLongId();
        params[1] = registyInfo.getServiceKey() == null ? " " : registyInfo.getServiceKey();
        params[2] = registyInfo.getServicePath() == null ? " " : registyInfo.getServicePath();
        params[3] = registyInfo.fullUrl == null ? " " : registyInfo.fullUrl;
        params[4] = registyInfo.getAddress() == null ? " " : registyInfo.getAddress();
        params[5] = registyInfo.getInstanceId() == null ? " " : registyInfo.getInstanceId();
        Date date = new Date();
        params[6] = date;
        params[7] = date;
        params[8] = registyInfo.getClusterName();
        params[9] = registyInfo.categoryPath;
        boolean exists = RegistryCacheHelper.serviceHasInit(registyInfo.getServiceKey(), registyInfo.getInstanceId(), registyInfo.getClusterName(), registyInfo.categoryPath);
        if (MserviceCenterUtil.isLogEnable()) {
            logger.info(MserviceCenterUtil.toString(registyInfo));
        }
        if (!exists) {
            try {
                boolean addResult = DBUtil.execute(DBCongfigTypeEnum.DBREGISTRY, SAVE_SERVICE_SQL, params);
                if (!addResult) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{RegistryDBHelper.buildErrorMsg(registyInfo, null)});
                }
            }
            catch (SQLException e) {
                throw new KDException(BosErrorCode.bOS, RegistryDBHelper.buildErrorMsg(registyInfo, null), (Throwable)e);
            }
            try {
                Long id = RegistryDBHelper.queryInstanceId(registyInfo.getInstanceId(), registyInfo.getClusterName());
                if (id == null || id == 0L) {
                    RegistryDBHelper.insertLivingInStance(registyInfo.getInstanceId(), registyInfo.getClusterName());
                }
                RegistryCacheHelper.initService(registyInfo.getServiceKey(), registyInfo.getInstanceId(), registyInfo.getClusterName(), registyInfo.categoryPath);
            }
            catch (Throwable e) {
                logger.error("save living instance error", e);
            }
        } else if (MserviceCenterUtil.isLogEnable()) {
            logger.info("registyInfo exists!");
        }
    }

    public static void deleteRegistyInfo(RegistrationInfo registyInfo) {
        Object[] params = new Object[]{registyInfo.getServiceKey(), registyInfo.getInstanceId(), registyInfo.getClusterName()};
        try {
            boolean deleteResult = DBUtil.execute(DBCongfigTypeEnum.DBREGISTRY, DELETE_SERVICE_SQL, params);
            if (!deleteResult) {
                throw new KDException(BosErrorCode.bOS, new Object[]{RegistryDBHelper.buildErrorMsg(registyInfo, null)});
            }
            RegistryCacheHelper.clearService(registyInfo.getServiceKey(), registyInfo.getInstanceId(), registyInfo.getClusterName(), registyInfo.categoryPath);
        }
        catch (SQLException e) {
            throw new KDException(BosErrorCode.bOS, RegistryDBHelper.buildErrorMsg(registyInfo, null), (Throwable)e);
        }
    }

    public static List<RegistrationInfo> queryServiceByServiceKey(String serviceKey, String clusterName) {
        Map registrationInfoList = (Map)RegistryDBHelper.queryRegistryInfoByServiceKey(serviceKey, clusterName, new ResultHandler(){

            protected Map<String, RegistrationInfo> doHandle(ResultSet resultSet) throws SQLException {
                HashMap<String, Timestamp> dateMap = new HashMap<String, Timestamp>();
                HashMap<String, RegistrationInfo> tempRegistrationInfoList = new HashMap<String, RegistrationInfo>(8);
                Date latesActiveThreholdDate = DateUtils.plusSecondsWithDate((Date)new Date(), (int)(-MserviceCenterConstants.INSTANCE_STATUS_PERIOD.intValue() * MserviceCenterConstants.LIVING_PERIODS.intValue()));
                while (resultSet.next()) {
                    String serviceKey = resultSet.getString("FSERVICEIDENTITY");
                    String instanceId = resultSet.getString("FINSTANCEID");
                    Timestamp activeTime = resultSet.getTimestamp("FLASTACTIVETIME");
                    String categroyPath = resultSet.getString("FCATEGORYPATH");
                    String fullUrl = resultSet.getString("FFULLURL");
                    String key = serviceKey + "#" + instanceId;
                    Date date = (Date)dateMap.get(key);
                    if (!activeTime.after(latesActiveThreholdDate) || date != null && activeTime.compareTo(date) <= 0 || fullUrl.startsWith("consumer://")) continue;
                    dateMap.put(key, activeTime);
                    RegistrationInfo registrationInfo = new RegistrationInfo(null);
                    registrationInfo.fullUrl = fullUrl;
                    registrationInfo.setServiceKey(serviceKey);
                    registrationInfo.setInstanceId(instanceId);
                    registrationInfo.setUpdateTime((Date)activeTime);
                    registrationInfo.categoryPath = categroyPath;
                    tempRegistrationInfoList.put(key, registrationInfo);
                }
                return tempRegistrationInfoList;
            }
        });
        ArrayList<RegistrationInfo> registrationInfos = new ArrayList<RegistrationInfo>(registrationInfoList.values());
        registrationInfos.sort(new Comparator<RegistrationInfo>(){

            @Override
            public int compare(RegistrationInfo o1, RegistrationInfo o2) {
                return o1.getUpdateTime().compareTo(o2.getUpdateTime());
            }
        });
        return registrationInfos;
    }

    public static List<RegistrationInfo> queryRegistryInfoByInstanceId(List<String> instanceIds, String clusterName) {
        Object[] param;
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(QUERY_SERVICE_SQL1);
        if (instanceIds != null && instanceIds.size() > 0) {
            param = new Object[instanceIds.size() + 1];
            sqlBuilder.append(" where ").append("finstanceid in (");
            for (int i = 0; i < instanceIds.size(); ++i) {
                sqlBuilder.append("?");
                if (i != instanceIds.size() - 1) {
                    sqlBuilder.append(",");
                } else {
                    sqlBuilder.append(")");
                }
                param[i] = instanceIds.get(i);
            }
            sqlBuilder.append(" and fclusterName =? ");
            param[param.length - 1] = clusterName;
        } else {
            param = new Object[]{clusterName};
            sqlBuilder.append(" where ").append("fclusterName =? ");
        }
        try {
            List registyInfos = (List)DBUtil.query(DBCongfigTypeEnum.DBREGISTRY, sqlBuilder.toString(), param, new ResultHandler(){

                protected List<RegistrationInfo> doHandle(ResultSet resultSet) throws SQLException {
                    ArrayList<RegistrationInfo> tempeRegistyInfos = new ArrayList<RegistrationInfo>(8);
                    while (resultSet.next()) {
                        RegistrationInfo registyInfo = new RegistrationInfo(null);
                        registyInfo.setServiceKey(resultSet.getString("FSERVICEIDENTITY"));
                        registyInfo.fullUrl = resultSet.getString("FFULLURL");
                        registyInfo.setInstanceId(resultSet.getString("FINSTANCEID"));
                        Timestamp fupdatetime = resultSet.getTimestamp("FUPDATETIME");
                        registyInfo.setUpdateTime(fupdatetime == null ? null : new Date(fupdatetime.getTime()));
                        registyInfo.setClusterName(resultSet.getString("FCLUSTERNAME"));
                        tempeRegistyInfos.add(registyInfo);
                    }
                    return tempeRegistyInfos;
                }
            });
            return registyInfos;
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "queryServiceKey error", e);
        }
    }

    public static Long insertLivingInStance(String instanceId, String clusterName) throws SQLException {
        long id = ID.genLongId();
        boolean resutl = DBUtil.execute(DBCongfigTypeEnum.DBREGISTRY, SAVE_LIVINGINSTANCE_SQL, new Object[]{id, instanceId, clusterName});
        if (resutl) {
            return id;
        }
        return 0L;
    }

    public static Long queryInstanceId(String instanceId, String clusterName) {
        try {
            Long id = (Long)DBUtil.query(DBCongfigTypeEnum.DBREGISTRY, QUERY_LIVINGINSTANCE_SQL, new Object[]{instanceId, clusterName}, new ResultHandler(){

                protected Long doHandle(ResultSet resultSet) throws SQLException {
                    Long tempId = null;
                    if (resultSet.next()) {
                        tempId = resultSet.getLong(1);
                    }
                    return tempId;
                }
            });
            return id;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "queryInstanceId error", (Throwable)e);
        }
    }

    public static <T> T queryAllInstance(String clusterName, ResultHandler handler) {
        try {
            return DBUtil.query(DBCongfigTypeEnum.DBREGISTRY, QUERY_ALLLIVINGINSTANCE_SQL, new Object[]{clusterName}, handler);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "queryAllInstance error", (Throwable)e);
        }
    }

    public static boolean updateLastActiveTime(Long id) {
        try {
            return DBUtil.execute(DBCongfigTypeEnum.DBREGISTRY, UPDATE_LIVINGINSTANCE_SQL, new Object[]{id});
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "updateLastActiveTime error", e);
        }
    }

    public static boolean deleteLivingInstance(Collection<Long> ids) {
        Tuple<String, Object[]> tuple = RegistryDBHelper.buildDeleteLivingInstanceSqlAndParams(ids);
        if (tuple == null) {
            return true;
        }
        try {
            return DBUtil.execute(DBCongfigTypeEnum.DBREGISTRY, (String)tuple.item1, (Object[])tuple.item2);
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "updateLastActiveTime error", e);
        }
    }

    public static boolean deleteRegistryInfo(Collection<String> instanceIds, String clusterName) {
        Tuple<String, Object[]> tuple = RegistryDBHelper.buildDeleteRegistrySqlAndParams(instanceIds, clusterName);
        if (tuple == null) {
            return true;
        }
        try {
            return DBUtil.execute(DBCongfigTypeEnum.DBREGISTRY, (String)tuple.item1, (Object[])tuple.item2);
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "updateLastActiveTime error", e);
        }
    }

    public static boolean deleteRegistryAndLivingInstance(Collection<String> instanceIds, Collection<Long> ids, String clusterName) {
        Tuple<String, Object[]> tuple = RegistryDBHelper.buildDeleteRegistrySqlAndParams(instanceIds, clusterName);
        if (tuple == null) {
            return true;
        }
        Tuple<String, Object[]> tuple1 = RegistryDBHelper.buildDeleteLivingInstanceSqlAndParams(ids);
        ArrayList<Tuple<String, Object[]>> sqlAndParamList = new ArrayList<Tuple<String, Object[]>>(2);
        sqlAndParamList.add(tuple);
        sqlAndParamList.add(tuple1);
        try {
            return DBUtil.executeMultiSql(DBCongfigTypeEnum.DBREGISTRY, sqlAndParamList);
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "deleteRegistryAndLivingInstance error", e);
        }
    }

    private static Tuple<String, Object[]> buildDeleteRegistrySqlAndParams(Collection<String> instanceIds, String clusterName) {
        if (instanceIds == null || instanceIds.size() == 0) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        Object[] params = new Object[instanceIds.size() + 1];
        ArrayList<String> instanceIdsList = new ArrayList<String>(instanceIds);
        sqlBuilder.append(DELETE_SERVICE_SQL_PREFIX).append(" where ").append("finstanceid in (");
        for (int i = 0; i < instanceIds.size(); ++i) {
            sqlBuilder.append("?");
            if (i != instanceIds.size() - 1) {
                sqlBuilder.append(",");
            } else {
                sqlBuilder.append(")");
            }
            params[i] = instanceIdsList.get(i);
        }
        params[params.length - 1] = clusterName;
        sqlBuilder.append("and fclustername = ?");
        return Tuple.create((Object)sqlBuilder.toString(), (Object)params);
    }

    private static Tuple<String, Object[]> buildDeleteLivingInstanceSqlAndParams(Collection<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(DELETE_LIVINGINSTANCE_SQL).append(" where ").append("fid in (");
        for (int i = 0; i < ids.size(); ++i) {
            sqlBuilder.append("?");
            if (i != ids.size() - 1) {
                sqlBuilder.append(",");
                continue;
            }
            sqlBuilder.append(")");
        }
        return Tuple.create((Object)sqlBuilder.toString(), (Object)ids.toArray(new Long[ids.size()]));
    }

    private static <T> T queryRegistryInfoByServiceKey(String serviceKey, String clusterName, ResultHandler resultHandler) {
        Object[] params = new Object[]{serviceKey, clusterName};
        try {
            return DBUtil.query(DBCongfigTypeEnum.DBREGISTRY, QUERY_SERVICE_SQL, params, resultHandler);
        }
        catch (Throwable e) {
            throw new KDException(BosErrorCode.bOS, "queryRegistryInfoByServiceKey error,serviceKey:" + serviceKey, e);
        }
    }

    private static String buildErrorMsg(RegistrationInfo registyInfo, Long id) {
        StringBuilder errorBuilder = new StringBuilder("Operate registyInfo error:[id:");
        errorBuilder.append(id == null ? "" : id).append(",serviceKey:").append(registyInfo.getServiceKey()).append(",servicePath:").append(registyInfo.getServicePath()).append(",fullUrl:").append(registyInfo.fullUrl).append(",address:").append(registyInfo.getAddress()).append(",instanceId:").append(registyInfo.getInstanceId()).append("]");
        return errorBuilder.toString();
    }
}

