/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.db.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.center.common.MserviceCenterUtil;
import kd.bos.mservice.center.registry.db.DBRegistrant;
import kd.bos.mservice.center.registry.db.DBSubscriber;
import kd.bos.mservice.center.registry.db.util.RegistryCacheHelper;
import kd.bos.mservice.center.registry.db.util.RegistryDBHelper;
import kd.bos.mservice.kregistrycenter.CallNotify;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;

public class RegistryUtil {
    private static final Log logger = LogFactory.getLog(RegistryUtil.class);

    public static List<String> updateService(String versionKey, String serviceKey, String clusterName) {
        List<RegistrationInfo> registrationInfos = RegistryDBHelper.queryServiceByServiceKey(serviceKey, clusterName);
        if (registrationInfos == null || registrationInfos.size() == 0) {
            if (MserviceCenterUtil.isLogEnable()) {
                logger.info("updateService-->no registrationInfos,serviceKey:{},clusterName:{}", (Object)serviceKey, (Object)clusterName);
            }
            return Collections.emptyList();
        }
        ArrayList<String> urls = new ArrayList<String>(registrationInfos.size());
        HashSet<String> distinctUrls = new HashSet<String>(registrationInfos.size());
        HashSet<String> categoryPaths = new HashSet<String>(registrationInfos.size());
        HashSet<String> instanceIds = new HashSet<String>(registrationInfos.size());
        for (RegistrationInfo registrationInfo : registrationInfos) {
            distinctUrls.add(registrationInfo.fullUrl);
            categoryPaths.add(registrationInfo.categoryPath);
            instanceIds.add(registrationInfo.getInstanceId());
        }
        urls.addAll(distinctUrls);
        String version = RegistryCacheHelper.genVersion(instanceIds, clusterName, serviceKey);
        RegistryCacheHelper.hmsetVersionAndUrls(versionKey, version, urls, categoryPaths);
        String localVersion = RegistryCacheHelper.getLocalVersion(versionKey);
        if (localVersion != null) {
            if (!localVersion.equals(version)) {
                RegistryUtil.updateLocalCache(serviceKey, clusterName, urls, version);
                if (MserviceCenterUtil.isLogEnable()) {
                    logger.info("notifyChange-->clusterName:{},serviceKey:{},urls:{}", new Object[]{clusterName, serviceKey, JSON.toJSONString(urls)});
                }
                DBSubscriber.notifyChange(versionKey, urls, categoryPaths);
            } else if (MserviceCenterUtil.isLogEnable()) {
                logger.info("updateService-->version has been not changed!");
            }
        } else {
            RegistryUtil.updateLocalCache(serviceKey, clusterName, urls, version);
            if (MserviceCenterUtil.isLogEnable()) {
                logger.info("notifyChange-->clusterName:{},serviceKey:{},urls:{}", new Object[]{clusterName, serviceKey, JSON.toJSONString(urls)});
            }
            DBSubscriber.notifyChange(versionKey, urls, categoryPaths);
        }
        return urls;
    }

    public static void updateLocalCache(String serviceKey, String clusterName, List<String> urls, String version) {
        DBRegistrant.updateAll(urls, serviceKey, clusterName);
        RegistryCacheHelper.setLocalVersion(serviceKey + "&###&" + clusterName, version);
    }

    public static List<String> getUrls(String serviceKey, String clusterName) {
        List<RegistrationInfo> registrationInfos = RegistryDBHelper.queryServiceByServiceKey(serviceKey, clusterName);
        if (registrationInfos == null || registrationInfos.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> urls = new ArrayList<String>(registrationInfos.size());
        HashSet<String> distinctUrsl = new HashSet<String>(registrationInfos.size());
        for (RegistrationInfo registrationInfo : registrationInfos) {
            distinctUrsl.add(registrationInfo.fullUrl);
        }
        urls.addAll(distinctUrsl);
        return urls;
    }

    public static void notify(String categoryPath, List<String> providerList, CallNotify callNotify) {
        String[] suffixs;
        int index = categoryPath.lastIndexOf("/");
        String prefix = categoryPath.substring(0, index) + "/";
        for (String suffix : suffixs = categoryPath.substring(index + 1).split(",")) {
            callNotify.notifyChange(prefix + suffix, providerList);
        }
    }

    public static String getCallStack(StackTraceElement[] stackTraces) {
        StringBuilder stackBuilder = new StringBuilder();
        if (stackTraces == null || stackTraces.length == 0) {
            stackTraces = Thread.currentThread().getStackTrace();
        }
        for (int i = 0; i < stackTraces.length; ++i) {
            stackBuilder.append("       ").append(stackTraces[i].getClassName()).append(".").append(stackTraces[i].getMethodName()).append("(").append(stackTraces[i].getLineNumber()).append(")").append("\n");
            if (i > 10) break;
        }
        return stackBuilder.toString();
    }
}

