/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.center.registry.zookeeper;

import com.alibaba.dubbo.remoting.zookeeper.ChildListener;
import com.alibaba.dubbo.remoting.zookeeper.ZookeeperClient;
import com.alibaba.dubbo.remoting.zookeeper.curator.CuratorZookeeperClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.mservice.kregistrycenter.CallNotify;
import kd.bos.mservice.kregistrycenter.RegistrationInfo;
import kd.bos.mservice.kregistrycenter.spi.KRegistryCenter;
import kd.bos.zk.ZKFactory;

public class ZookeeperRegistryCenter
implements KRegistryCenter {
    private static Map<String, ZookeeperClient> clients = new ConcurrentHashMap<String, ZookeeperClient>(2);
    private static final String PATH_SEPARATOR = "/";
    private final ConcurrentMap<CallNotify, ChildListener> zkListeners = new ConcurrentHashMap<CallNotify, ChildListener>();

    public void doSaveRegister(RegistrationInfo registrationInfoZK) {
        ZookeeperClient zkClient = this.getClient(registrationInfoZK);
        zkClient.create(this.toUrlPath(registrationInfoZK), registrationInfoZK.isEphemeral());
    }

    public void doRemoveRegister(RegistrationInfo registrationInfoZK) {
        ZookeeperClient zkClient = this.getClient(registrationInfoZK);
        zkClient.delete(this.toUrlPath(registrationInfoZK));
    }

    public void doAddSubscribeListener(RegistrationInfo registrationInfoZK, CallNotify callNotify) {
        ZookeeperClient zkClient = this.getClient(registrationInfoZK);
        ChildListener zkListener = this.zkListeners.computeIfAbsent(callNotify, k -> (parentPath, currentChilds) -> callNotify.notifyChange(parentPath, currentChilds));
        for (String path : registrationInfoZK.categoriesPath) {
            path = registrationInfoZK.getRootPath() + path;
            zkClient.create(path, false);
            List children = zkClient.addChildListener(path, zkListener);
            callNotify.notifyChange(path, children);
        }
    }

    public void doRemoveSubscribeListener(RegistrationInfo registrationInfoZK, CallNotify callNotify) {
        ChildListener zkListener = (ChildListener)this.zkListeners.get(callNotify);
        if (zkListener != null) {
            ZookeeperClient zkClient = this.getClient(registrationInfoZK);
            zkClient.removeChildListener(this.toUrlPath(registrationInfoZK), zkListener);
        }
    }

    public List<String> getProviderList(RegistrationInfo registrationInfoZK, String path) {
        ZookeeperClient zkClient = this.getClient(registrationInfoZK);
        return zkClient.getChildren(registrationInfoZK.getRootPath() + path);
    }

    private String toUrlPath(RegistrationInfo registrationInfoZK) {
        return registrationInfoZK.getRootPath() + registrationInfoZK.categoryPath + PATH_SEPARATOR + ZookeeperRegistryCenter.encode(registrationInfoZK.fullUrl);
    }

    private static String encode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ZookeeperClient getClient(RegistrationInfo registrationInfoZK) {
        String username = registrationInfoZK.registryCenterInfo.getUser();
        String pd = registrationInfoZK.registryCenterInfo.getPasswd();
        String address = registrationInfoZK.registryCenterInfo.getAddress();
        String registryUrl = username == null || pd == null ? address : address + "?username=" + username + ":password=" + pd;
        return clients.computeIfAbsent(registryUrl, k -> new CuratorZookeeperClient(ZKFactory.getZKClient((String)registryUrl)));
    }

    public boolean isRegistryEphemeral() {
        return true;
    }
}

