/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.sql.DataSource;

public final class KDSecurityClassLoader
extends URLClassLoader {
    private static final Set<String> ignoreFailInjectClassSet = new HashSet<String>();
    private final Set<String> customerClassSet = new HashSet<String>();
    private Class<?> kdSecurityDriverClass = null;
    private Class<?> kdSecurityDataSourceClass = null;
    private Function<String, Boolean> kdSecurityConfig_allowCustomerDefineClass;
    private Map<String, Set<String>> accountDynamicJarClassMap = new ConcurrentHashMap<String, Set<String>>();
    private static final String EXT_CLASS_LOADER = "kd.bos.dataentity.ext.ExtClassLoader";
    private static final String KDSECURITY_CLASS_LOADER = "kd.bos.security.KDSecurityClassLoader";
    private static volatile Method mDoFindDynamicClass;
    private static volatile Method mDoSetDynamicJar;
    private static volatile Method mDoRemoveDynamicJar;
    private static volatile Method requestContext_get;
    private static Method requestContext_getAccountId;

    public KDSecurityClassLoader(ClassLoader parent) {
        super(((URLClassLoader)parent).getURLs(), parent.getParent());
    }

    private boolean isCustomerClass(Class<?> cls) {
        return this.customerClassSet.contains(cls.getName()) || this.isDynamicClass(cls);
    }

    private boolean isCustomerClass(String className) {
        return this.customerClassSet.contains(className) || this.isDynamicClass(className);
    }

    private void initialize() throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class<?> kdSecurityConfigClass = this.loadClass("kd.bos.security.KDSecurityConfig");
        Method get = kdSecurityConfigClass.getDeclaredMethod("get", new Class[0]);
        get.setAccessible(true);
        Object config = get.invoke(null, new Object[0]);
        Method isCustomerLibURL = kdSecurityConfigClass.getDeclaredMethod("isCustomerLibURL", URL.class);
        isCustomerLibURL.setAccessible(true);
        Function<URL, Boolean> kdSecurityConfig_isCustomerLibURL = url -> {
            try {
                return (Boolean)isCustomerLibURL.invoke(config, url);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        Method allowCustomerDefineClass = kdSecurityConfigClass.getDeclaredMethod("allowCustomerDefineClass", String.class);
        allowCustomerDefineClass.setAccessible(true);
        this.kdSecurityConfig_allowCustomerDefineClass = className -> {
            try {
                return (Boolean)allowCustomerDefineClass.invoke(config, className);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        URL[] urls = this.getURLs();
        int c = 0;
        for (URL url2 : urls) {
            if (!kdSecurityConfig_isCustomerLibURL.apply(url2).booleanValue()) continue;
            ++c;
            try (JarFile jarFile = new JarFile(url2.getFile());){
                this.findClassesByJar(jarFile, this.customerClassSet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void findClassesByJar(JarFile jar, Set<String> nameSet) {
        Enumeration<JarEntry> em = jar.entries();
        while (em.hasMoreElements()) {
            String name;
            JarEntry entry = em.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class")) continue;
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            name = name.substring(0, name.length() - 6).replace('/', '.');
            nameSet.add(name);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        this.checkAllowDefine(name);
        Class<?> c = super.findClass(name);
        this.checkAllowLoadClass(c);
        return c;
    }

    private void checkAllowDefine(String className) {
        if (this.isCustomerClass(className) && this.kdSecurityConfig_allowCustomerDefineClass != null && !this.kdSecurityConfig_allowCustomerDefineClass.apply(className).booleanValue()) {
            throw new SecurityException("\u7981\u6b62\u5b9a\u4e49\u7c7b(\u5305\u540d\u53d7\u9650): " + className);
        }
    }

    private void checkAllowLoadClass(Class<?> c) {
        if (this.isCustomerClass(c)) {
            String err = null;
            if (ClassLoader.class.isAssignableFrom(c)) {
                err = "\u7981\u6b62\u81ea\u5b9a\u4e49ClassLoader: " + c.getName();
            } else if (Driver.class.isAssignableFrom(c)) {
                err = "\u7981\u6b62\u81ea\u5b9a\u4e49Driver: " + c.getName();
            }
            if (err != null) {
                new Throwable("\u9047\u5230\u4e25\u91cd\u5b89\u5168\u95ee\u9898\uff0c\u9000\u51fa\u7cfb\u7edf\uff01" + err).printStackTrace();
                System.exit(-1);
            }
        } else if (!c.isInterface() && !Modifier.isAbstract(c.getModifiers())) {
            if (Driver.class.isAssignableFrom(c) && !ignoreFailInjectClassSet.contains(c.getName())) {
                if (this.kdSecurityDriverClass == null) {
                    try {
                        this.kdSecurityDriverClass = this.loadClass("kd.bos.security.KDSecurityDriver");
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!this.kdSecurityDriverClass.isAssignableFrom(c)) {
                    new Throwable("Driver\u7c7b\u672a\u505a\u5b89\u5168\u6ce8\u5165\uff0c\u9000\u51fa\u7cfb\u7edf\uff01class=" + c.getName()).printStackTrace();
                    System.exit(-1);
                }
            } else if (DataSource.class.isAssignableFrom(c) && !ignoreFailInjectClassSet.contains(c.getName())) {
                if (this.kdSecurityDataSourceClass == null) {
                    try {
                        this.kdSecurityDataSourceClass = this.loadClass("kd.bos.security.KDSecurityDataSource");
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!this.kdSecurityDataSourceClass.isAssignableFrom(c)) {
                    new Throwable("DataSource\u7c7b\u672a\u505a\u5b89\u5168\u6ce8\u5165\uff0c\u9000\u51fa\u7cfb\u7edf\uff01class=" + c.getName()).printStackTrace();
                    System.exit(-1);
                }
            }
        }
    }

    private Class<?> doFindDynamicClass(String name, Callable<Class<?>> extClassLoaderFindClass) {
        this.checkAllowDefine(name);
        try {
            Class<?> c = extClassLoaderFindClass.call();
            this.checkAllowLoadClass(c);
            return c;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private boolean isDynamicClass(Class<?> cls) {
        if (Thread.currentThread().getContextClassLoader() == this && cls.getClassLoader() != null) {
            return EXT_CLASS_LOADER.equals(cls.getClassLoader().getClass().getName());
        }
        return false;
    }

    private boolean isDynamicClass(String name) {
        String accountId;
        if (!this.accountDynamicJarClassMap.isEmpty() && Thread.currentThread().getContextClassLoader() == this && (accountId = KDSecurityClassLoader.getAccountId()) != null) {
            Set<String> set = this.accountDynamicJarClassMap.get(accountId);
            return set != null && set.contains(name);
        }
        return false;
    }

    private void doSetDynamicJar(String accountId, URL url) {
        ConcurrentSkipListSet<String> set = new ConcurrentSkipListSet<String>();
        this.accountDynamicJarClassMap.put(accountId, set);
        HashSet<String> dynamicClassSet = new HashSet<String>();
        try (JarFile jarFile = new JarFile(url.getFile());){
            this.findClassesByJar(jarFile, dynamicClassSet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        set.addAll(dynamicClassSet);
    }

    private void doRemoveDynamicJar(String accountId) {
        this.accountDynamicJarClassMap.remove(accountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String getAccountId() {
        try {
            Object rc;
            if (requestContext_get == null) {
                Class<KDSecurityClassLoader> clazz = KDSecurityClassLoader.class;
                // MONITORENTER : kd.bos.security.KDSecurityClassLoader.class
                if (requestContext_get == null) {
                    Class<?> requestContextCls = Class.forName("kd.bos.context.RequestContext");
                    requestContext_getAccountId = requestContextCls.getMethod("getAccountId", new Class[0]);
                    requestContext_get = requestContextCls.getMethod("get", new Class[0]);
                }
                // MONITOREXIT : clazz
            }
            if ((rc = requestContext_get.invoke(null, new Object[0])) == null) {
                return null;
            }
            String string = (String)requestContext_getAccountId.invoke(rc, new Object[0]);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setAccountJar(String accountId, URL jarURL) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!KDSECURITY_CLASS_LOADER.equals(cl.getClass().getName())) return;
        try {
            if (mDoSetDynamicJar == null) {
                Class<KDSecurityClassLoader> clazz = KDSecurityClassLoader.class;
                // MONITORENTER : kd.bos.security.KDSecurityClassLoader.class
                Method temp = cl.getClass().getDeclaredMethod("doSetDynamicJar", String.class, URL.class);
                temp.setAccessible(true);
                if (mDoSetDynamicJar == null) {
                    mDoSetDynamicJar = temp;
                }
                // MONITOREXIT : clazz
            }
            mDoSetDynamicJar.invoke((Object)cl, accountId, jarURL);
            return;
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void removeAccountJar(String accountId) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!KDSECURITY_CLASS_LOADER.equals(cl.getClass().getName())) return;
        try {
            if (mDoRemoveDynamicJar == null) {
                Class<KDSecurityClassLoader> clazz = KDSecurityClassLoader.class;
                // MONITORENTER : kd.bos.security.KDSecurityClassLoader.class
                Method temp = cl.getClass().getDeclaredMethod("doRemoveDynamicJar", String.class);
                temp.setAccessible(true);
                if (mDoRemoveDynamicJar == null) {
                    mDoRemoveDynamicJar = temp;
                }
                // MONITOREXIT : clazz
            }
            mDoRemoveDynamicJar.invoke((Object)cl, accountId);
            return;
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void findAccountClass(String name, Callable<Class<?>> extClassLoaderFindClass) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!KDSECURITY_CLASS_LOADER.equals(cl.getClass().getName())) return;
        try {
            if (mDoFindDynamicClass == null) {
                Class<KDSecurityClassLoader> clazz = KDSecurityClassLoader.class;
                // MONITORENTER : kd.bos.security.KDSecurityClassLoader.class
                Method temp = cl.getClass().getDeclaredMethod("doFindDynamicClass", String.class, Callable.class);
                temp.setAccessible(true);
                if (mDoFindDynamicClass == null) {
                    mDoFindDynamicClass = temp;
                }
                // MONITOREXIT : clazz
            }
            mDoFindDynamicClass.invoke((Object)cl, name, extClassLoaderFindClass);
            return;
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
        ignoreFailInjectClassSet.add("com.amazon.redshift.core.jdbc42.PGJDBC42DataSource");
        ignoreFailInjectClassSet.add("com.microsoft.sqlserver.jdbc.SQLServerDataSource");
        ignoreFailInjectClassSet.add("com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource");
        ignoreFailInjectClassSet.add("com.microsoft.sqlserver.jdbc.SQLServerXADataSource");
    }
}

