/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import java.net.URL;
import kd.bos.security.KDReflection;
import kd.bos.security.KDSecurityManager;

final class KDSecurityConfig {
    private static final KDSecurityConfig instance = new KDSecurityConfig();
    private static final String CUS_LIB_END_PATH = "/lib/cus/";
    private static final String KD_PACKAGE_PREFIX = "kd.";
    private static boolean allowCustomerDefineKDPackageClass = false;

    static KDSecurityConfig get() {
        return instance;
    }

    private KDSecurityConfig() {
    }

    boolean isCustomerLibURL(URL url) {
        String jarName;
        String path = url.toString();
        int p = path.lastIndexOf(CUS_LIB_END_PATH);
        return p != -1 && (jarName = path.substring(p + CUS_LIB_END_PATH.length())).indexOf(47) == -1;
    }

    boolean allowSuppressAccess(Class<?> callerClass) {
        return !KDSecurityManager.isCustomerClass(callerClass);
    }

    boolean allowCustomerDefineClass(String defineClassName) {
        if (defineClassName.startsWith("kd.bos.") && (defineClassName.startsWith("kd.bos.security.") || defineClassName.startsWith("kd.bos.db.") || defineClassName.startsWith("kd.bos.xdb.") || defineClassName.startsWith("kd.bos.mc.") || defineClassName.startsWith("kd.bos.tenant."))) {
            return false;
        }
        return allowCustomerDefineKDPackageClass || !defineClassName.startsWith(KD_PACKAGE_PREFIX);
    }

    boolean allowExit(Class<?> callerClass) {
        return !KDReflection.isCustomerClass(callerClass);
    }

    boolean allowExec(Class<?> callerClass) {
        return !KDReflection.isCustomerClass(callerClass);
    }

    boolean allowLoadLibrary(Class<?> callerClass) {
        return !KDReflection.isCustomerClass(callerClass);
    }

    boolean allowAccessThread(Class<?> callerClass) {
        return !KDReflection.isCustomerClass(callerClass);
    }

    boolean allowAccessThreadGroup(Class<?> callerClass) {
        return !KDReflection.isCustomerClass(callerClass);
    }

    boolean allowCreateClassLoader(Class<?> callerClass) {
        return !KDReflection.isCustomerClass(callerClass);
    }

    static {
        allowCustomerDefineKDPackageClass = Boolean.getBoolean("kd.security.allow_customer_define_kd");
    }
}

