/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import kd.bos.security.InjectResources;
import kd.bos.security.KDReflection;

public interface KDSecurityDriver {
    public static final String DRIVER_CONSTRUCTOR_CHECK_CODE = "checkDriverSecurityCall();";

    default public void checkDriverSecurityCall() {
        KDReflection.forbidCustomerNewDriver(this.getClass());
    }

    public static Callable<Object> injectDrivers() throws Throwable {
        ArrayList<CtClass> toFrozenList = new ArrayList<CtClass>(InjectResources.drivers.length);
        ClassPool pool = ClassPool.getDefault();
        CtClass interfaceCls = pool.getCtClass(KDSecurityDriver.class.getName());
        for (String driver : InjectResources.drivers) {
            if (KDReflection.isCustomerClass(driver)) continue;
            try {
                CtClass cls = pool.getCtClass(driver);
                toFrozenList.add(cls);
                cls.addInterface(interfaceCls);
                for (CtConstructor cc : cls.getConstructors()) {
                    cc.insertAfter(DRIVER_CONSTRUCTOR_CHECK_CODE);
                }
            }
            catch (NotFoundException notFoundException) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return () -> {
            for (CtClass cls : toFrozenList) {
                if (cls.isFrozen()) continue;
                try {
                    cls.toClass();
                    cls.detach();
                }
                catch (Exception exception) {}
            }
            return null;
        };
    }
}

