/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.security;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.Permission;
import java.sql.Driver;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import javax.management.MBeanTrustPermission;
import kd.bos.security.KDCallerInfo;
import kd.bos.security.KDReflection;
import kd.bos.security.KDSecurityClassLoader;
import kd.bos.security.KDSecurityConfig;
import kd.bos.security.KDSecurityDataSource;
import kd.bos.security.KDSecurityDriver;

public final class KDSecurityManager
extends SecurityManager {
    private static KDSecurityManager instance;
    private static Function<Class<?>, Boolean> isCustomerClass1;
    private static Function<String, Boolean> isCustomerClass2;
    private static Set<String> ignoreCheckSecurityAccessSet;
    private static final AtomicBoolean initialized;
    protected static boolean enableSecurity;
    private final KDSecurityConfig config = KDSecurityConfig.get();

    public static KDSecurityManager get() {
        if (instance == null) {
            System.err.println("Warning: KDSecurityManager should call initialize first.");
            KDSecurityManager.initialize();
        }
        return instance;
    }

    public static void initialize() {
        if (initialized.compareAndSet(false, true)) {
            try {
                Class.forName(KDCallerInfo.class.getName());
                Class.forName(KDReflection.class.getName());
                Class.forName(KDSecurityConfig.class.getName());
                Class.forName(KDSecurityDataSource.class.getName());
                Class.forName(KDSecurityDriver.class.getName());
                Class.forName(Driver.class.getName());
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl instanceof KDSecurityClassLoader) {
                    enableSecurity = true;
                    ignoreCheckSecurityAccessSet = KDSecurityManager.loadIgnoreCheckSecurityAccess();
                    Method method = cl.getClass().getDeclaredMethod("initialize", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)cl, new Object[0]);
                    Method m1 = cl.getClass().getDeclaredMethod("isCustomerClass", Class.class);
                    m1.setAccessible(true);
                    isCustomerClass1 = cls -> {
                        try {
                            return (Boolean)m1.invoke((Object)cl, cls);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                    Method m2 = cl.getClass().getDeclaredMethod("isCustomerClass", String.class);
                    m2.setAccessible(true);
                    isCustomerClass2 = cls -> {
                        try {
                            return (Boolean)m2.invoke((Object)cl, cls);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                    Callable<Object> f1 = KDSecurityDriver.injectDrivers();
                    Callable<Object> f2 = KDSecurityDataSource.injectDataSources();
                    f1.call();
                    f2.call();
                } else {
                    System.err.println("[KDSecurity-warning] VM arguments is not set: -Djava.system.class.loader=kd.bos.security.KDSecurityClassLoader");
                }
            }
            catch (Throwable e) {
                System.err.println("\u5b89\u5168\u7ba1\u7406\u5668KDSecurityManager\u521d\u59cb\u5316\u5931\u8d25\uff0c\u9000\u51fa\u7cfb\u7edf\uff01");
                e.printStackTrace();
                LockSupport.parkNanos(1000000000L);
                System.exit(-1);
            }
            instance = new KDSecurityManager();
        }
    }

    /*
     * Exception decompiling
     */
    private static Set<String> loadIgnoreCheckSecurityAccess() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean isCustomerClass(Class<?> cls) {
        return isCustomerClass1 != null && isCustomerClass1.apply(cls) != false;
    }

    static boolean isCustomerClass(String className) {
        return isCustomerClass2 != null && isCustomerClass2.apply(className) != false;
    }

    private KDSecurityManager() {
        if (enableSecurity) {
            System.setSecurityManager(this);
        }
    }

    @Override
    public Class<?>[] getClassContext() {
        return super.getClassContext();
    }

    private void log(String msg) {
    }

    @Override
    public void checkAccept(String host, int port) {
    }

    @Override
    public void checkAccess(Thread t) {
        KDCallerInfo caller = KDReflection.getCallerClassUntilNot(Thread.class);
        if (!this.config.allowAccessThread(caller.getCallerClass())) {
            String msg = "\u9650\u5236\u8bbe\u7f6eThread: " + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName(caller.getCallStackDepth()) + ", thread = " + t;
            System.err.println(msg);
            throw new SecurityException(msg);
        }
        super.checkAccess(t);
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        KDCallerInfo caller = KDReflection.getCallerClassUntilNot(Thread.class);
        if (!this.config.allowAccessThreadGroup(caller.getCallerClass())) {
            String msg = "\u9650\u5236\u8bbe\u7f6eThreadGroup: " + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName(caller.getCallStackDepth()) + ", thread group = " + g;
            System.err.println(msg);
            throw new SecurityException(msg);
        }
    }

    public void checkAwtEventQueueAccess() {
    }

    @Override
    public void checkConnect(String host, int port) {
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
    }

    @Override
    public void checkCreateClassLoader() {
        KDCallerInfo caller;
        if (!KDReflection.isInflationCreateClassLoader() && !this.config.allowCreateClassLoader((caller = KDReflection.getCallerClassUntilNotAssignableFrom(ClassLoader.class)).getCallerClass())) {
            throw new SecurityException("\u9650\u5236\u4f7f\u7528\u7cfb\u7edf\u5916ClassLoader: " + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName(caller.getCallStackDepth()));
        }
    }

    @Override
    public void checkDelete(String file) {
    }

    @Override
    public void checkExec(String cmd) {
        KDCallerInfo caller = KDReflection.getCallerClassUntilNot(ProcessBuilder.class, Runtime.class);
        if (!this.config.allowExec(caller.getCallerClass())) {
            throw new SecurityException("\u9650\u5236\u6267\u884c\u547d\u4ee4: " + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName(caller.getCallStackDepth()) + ", cmd = " + cmd);
        }
    }

    @Override
    public void checkExit(int status) {
        KDCallerInfo caller = KDReflection.getCallerClassUntilNot(Runtime.class, System.class);
        if (!this.config.allowExit(caller.getCallerClass())) {
            throw new SecurityException("\u9650\u5236\u6267\u884cexit: " + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName(caller.getCallStackDepth()) + ", exit status = " + status);
        }
    }

    @Override
    public void checkLink(String lib) {
        KDCallerInfo caller = KDReflection.getCallerClassUntilNot(Runtime.class, System.class);
        if (!this.config.allowLoadLibrary(caller.getCallerClass())) {
            throw new SecurityException("\u9650\u5236\u6267\u884cLoadLibrary: " + caller.getCallerClass().getName() + "#" + KDReflection.getCallerMethodName(caller.getCallStackDepth()) + ", lib = " + lib);
        }
    }

    @Override
    public void checkListen(int port) {
    }

    public void checkMemberAccess(Class<?> clazz, int which) {
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
    }

    @Override
    public void checkMulticast(InetAddress maddr, byte ttl) {
    }

    @Override
    public void checkPackageAccess(String pkg) {
    }

    @Override
    public void checkPackageDefinition(String pkg) {
    }

    @Override
    public void checkPrintJobAccess() {
    }

    @Override
    public void checkPropertiesAccess() {
        if (KDReflection.isCustomerClass(KDReflection.getCallerCallerClass())) {
            throw new SecurityException("\u7981\u6b62\u8bbf\u95ee\uff1aSystem.getProperties()");
        }
    }

    @Override
    public void checkPropertyAccess(String key) {
        if (key.startsWith("mc.tenant.") && KDReflection.isCustomerClass(KDReflection.getCallerCallerClass())) {
            throw new SecurityException("\u7981\u6b62\u8bbf\u95eeSystem.property\uff1amc.tenant.*");
        }
    }

    @Override
    public void checkRead(FileDescriptor fd) {
    }

    @Override
    public void checkRead(String file) {
    }

    @Override
    public void checkRead(String file, Object context) {
    }

    @Override
    public void checkSecurityAccess(String target) {
        if (!(target.startsWith("get") || target.startsWith("putProviderProperty.") || target.startsWith("insertProvider") || ignoreCheckSecurityAccessSet.contains(target))) {
            throw new SecurityException("\u7981\u6b62\u4fee\u6539\u5b89\u5168\u7b56\u7565\u5185\u5bb9: " + target);
        }
    }

    @Override
    public void checkSetFactory() {
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean checkTopLevelWindow(Object window) {
        return super.checkTopLevelWindow(window);
    }

    @Override
    public void checkWrite(FileDescriptor fd) {
    }

    @Override
    public void checkWrite(String file) {
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (!(perm instanceof MBeanTrustPermission)) {
            super.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPermission(Permission perm) {
        switch (perm.getName()) {
            case "setContextClassLoader": {
                Class<?> callerCallerClass = KDReflection.getCallerCallerClass();
                if (!KDReflection.isCustomerClass(callerCallerClass)) break;
                throw new SecurityException("\u7981\u6b62setContextClassLoader" + this.getClass().getName());
            }
            case "setSecurityManager": {
                throw new SecurityException("\u7981\u6b62\u66ff\u6362" + this.getClass().getName());
            }
            case "suppressAccessChecks": {
                Class<?> callerClass;
                if (KDReflection.isInflationSuppressAccess() || this.config.allowSuppressAccess(callerClass = KDReflection.getCallerCallerClass())) break;
                throw new SecurityException("\u9650\u5236\u66f4\u6539\u8bbf\u95ee\u6743\u9650(setAccessible): " + callerClass.getName() + "#" + KDReflection.getCallerCallerMethodName());
            }
            case "reflectionFactoryAccess": {
                Class<?> callerClass = KDReflection.getCallerCallerClass();
                if (this.config.allowSuppressAccess(callerClass)) break;
                throw new SecurityException("\u9650\u5236\u8d8a\u6743\u8bbf\u95ee(ReflectionFactory): " + callerClass.getName() + "#" + KDReflection.getCallerCallerMethodName());
            }
            case "stopThread": {
                Class<?> callerClass = KDReflection.getCallerCallerClass();
                if (this.config.allowSuppressAccess(callerClass)) break;
                throw new SecurityException("\u9650\u5236stopThread: " + callerClass.getName() + "#" + KDReflection.getCallerCallerMethodName());
            }
            case "setIO": {
                Class<?> callerClass = KDReflection.getCallerCallerClass();
                if (this.config.allowSuppressAccess(callerClass)) break;
                throw new SecurityException("\u9650\u5236setIO: " + callerClass.getName() + "#" + KDReflection.getCallerCallerMethodName());
            }
            case "readDisplayPixels": {
                Class<?> callerClass = KDReflection.getCallerCallerClass();
                if (this.config.allowSuppressAccess(callerClass)) break;
                throw new SecurityException("\u9650\u5236readDisplayPixels(robot): " + callerClass.getName() + "#" + KDReflection.getCallerCallerMethodName());
            }
        }
    }

    static {
        initialized = new AtomicBoolean();
        enableSecurity = false;
    }
}

