/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.sdk.init.AbstractInitTable;
import kd.bos.kdtx.sdk.init.LocalTccTableInit;
import kd.bos.kdtx.sdk.init.LocalTxTableInit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TableInitConfig {
    private static final Log logger = LogFactory.getLog(TableInitConfig.class);
    private static Map<String, Boolean> initMap = new ConcurrentHashMap<String, Boolean>(4);
    private List<AbstractInitTable> initTableList = new ArrayList<AbstractInitTable>(2);
    private String routeKey;
    private int txType;
    private static TableInitConfig tccInstance = null;
    private static TableInitConfig ecInstance = null;

    private TableInitConfig(int txType) {
        if (txType == DtxType.TCC.getCode()) {
            this.initTableList.add(new LocalTccTableInit());
        } else {
            this.initTableList.add(new LocalTxTableInit());
        }
        this.txType = txType;
    }

    public static synchronized TableInitConfig getInstance(int txType) {
        if (txType == DtxType.TCC.getCode()) {
            return tccInstance != null ? tccInstance : (tccInstance = new TableInitConfig(txType));
        }
        return ecInstance != null ? ecInstance : (ecInstance = new TableInitConfig(txType));
    }

    public boolean isInit(String routeKey) {
        if (!DtxConfig.getBizTableAutoInit()) {
            return true;
        }
        return initMap.getOrDefault(this.getKey(routeKey), false);
    }

    public static void initLocalTable(int txType, DBRoute dbRoute) {
        if (dbRoute != null && !TableInitConfig.getInstance(txType).isInit(dbRoute.getRouteKey())) {
            TableInitConfig.getInstance(txType).initTables(dbRoute.getRouteKey());
        }
    }

    private String getKey(String routeKey) {
        StringBuilder sb = new StringBuilder(RequestContext.get().getTenantId());
        sb.append("_");
        sb.append(RequestContext.get().getAccountId());
        sb.append("_");
        sb.append(routeKey);
        sb.append("_");
        sb.append(this.txType);
        return sb.toString();
    }

    public synchronized void initTables(String routeKey) {
        try (TXHandle tx = TX.requiresNew();){
            this.routeKey = routeKey;
            Map<String, Integer> tableMap = this.query(routeKey);
            if (tableMap != null && tableMap.size() > 0) {
                this.handleTableMete(tableMap);
                return;
            }
            this.initTableList.forEach(l -> {
                boolean exists = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)l.getTableName());
                if (exists) {
                    this.executeAlterSql((AbstractInitTable)l);
                } else {
                    DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)l.getCreateTableSql());
                    this.createIndex((AbstractInitTable)l);
                    this.saveBizTableMeta((AbstractInitTable)l);
                }
            });
            initMap.put(this.getKey(routeKey), true);
        }
    }

    private void saveBizTableMeta(AbstractInitTable tableClass) {
        String sql = "insert into t_cbs_dtx_biztable_meta(fid, fdbroute_key,ftable_name,fversion,fcreate_time,fupdate_time) values(?,?,?,?,now(),now())";
        try (TXHandle txHandle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{ID.genLongId(), this.routeKey, tableClass.getTableName(), tableClass.getVersion()});
        }
    }

    private void updateVersionBizTableMeta(AbstractInitTable tableClass) {
        String sql = "update t_cbs_dtx_biztable_meta set fversion = ?, fupdate_time = now() where fdbroute_key = ? and ftable_name=?";
        try (TXHandle txHandle = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{tableClass.getVersion(), this.routeKey, tableClass.getTableName()});
        }
    }

    private Map<String, Integer> query(String routeKey) {
        HashMap tableMap = new HashMap(4);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftable_name, fversion from t_cbs_dtx_biztable_meta where fdbroute_key = ? and ", new Object[]{routeKey});
        ArrayList<String> names = new ArrayList<String>(2);
        for (AbstractInitTable tableClass : this.initTableList) {
            names.add(tableClass.getTableName());
        }
        sqlBuilder.appendIn("ftable_name", names);
        return (Map)DB.query((DBRoute)DBRoute.base, (SqlBuilder)sqlBuilder, rs -> {
            while (rs.next()) {
                tableMap.put(rs.getString(1), rs.getInt(2));
            }
            return tableMap;
        });
    }

    private void handleTableMete(Map<String, Integer> tableMap) {
        for (AbstractInitTable tableClass : this.initTableList) {
            if (!tableMap.containsKey(tableClass.getTableName())) {
                DB.execute((DBRoute)DBRoute.of((String)this.routeKey), (String)tableClass.getCreateTableSql());
                this.createIndex(tableClass);
                this.saveBizTableMeta(tableClass);
                continue;
            }
            Map<Integer, List<String>> alterMap = tableClass.getAlterTableSql();
            if (alterMap == null) continue;
            alterMap.forEach((tableVersion, sqlList) -> {
                if (tableVersion > (Integer)tableMap.get(tableClass.getTableName())) {
                    sqlList.forEach(l -> DB.execute((DBRoute)DBRoute.of((String)this.routeKey), (String)l));
                    this.updateVersionBizTableMeta(tableClass);
                }
            });
        }
        initMap.put(this.getKey(this.routeKey), true);
    }

    private void executeAlterSql(AbstractInitTable tableClass) {
        this.saveBizTableMeta(tableClass);
        Map<Integer, List<String>> alterMap = tableClass.getAlterTableSql();
        if (alterMap != null) {
            alterMap.forEach((tableVersion, sqlList) -> {
                sqlList.forEach(l -> DB.execute((DBRoute)DBRoute.of((String)this.routeKey), (String)l));
                this.updateVersionBizTableMeta(tableClass);
            });
        }
    }

    private void createIndex(AbstractInitTable tableClass) {
        List<String> createIndexSql = tableClass.getCreateIndexSql();
        if (createIndexSql != null) {
            for (String sql : createIndexSql) {
                DB.execute((DBRoute)DBRoute.of((String)this.routeKey), (String)sql);
            }
        }
    }
}

