/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.kdtx.common.constant.TCCMethod;
import kd.bos.kdtx.common.dto.BranchInvokerParam;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.exception.invoke.BranchBizException;
import kd.bos.kdtx.common.service.DtxBranchDispatchService;
import kd.bos.kdtx.common.service.KdtxSerializer;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.response.ResponseHeader;
import kd.bos.util.StringUtils;

public class KdtxBranchDispatchServiceImpl
implements DtxBranchDispatchService {
    private static final Log log = LogFactory.getLog(KdtxBranchDispatchServiceImpl.class);
    private static final String audit_name = "tcc_mservice_cost";
    private Map<String, Object> serviceObjectMap = new ConcurrentHashMap<String, Object>();
    private Map<String, Method> serviceMethodMap = new ConcurrentHashMap<String, Method>();

    public void prepare(String appServiceFactory, String resourceName, Object ... paras) throws Exception {
        this.invoke(appServiceFactory, resourceName, TCCMethod.TRY, paras);
    }

    public Object commit(String appServiceFactory, String resourceName, Object ... paras) throws Exception {
        return this.invoke(appServiceFactory, resourceName, TCCMethod.CONFIRM, paras);
    }

    public void rollback(String appServiceFactory, String resourceName, Object ... paras) throws Exception {
        this.invoke(appServiceFactory, resourceName, TCCMethod.CANCEL, paras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(String appServiceFactory, String resourceName, TCCMethod tccMethod, Object ... paras) {
        String serviceKey = appServiceFactory + resourceName;
        Object result = null;
        try {
            Method serviceMethod;
            BranchInvokerParam branchInvokerParam = (BranchInvokerParam)paras[0];
            Object paramObject = this.getBizParam(branchInvokerParam);
            Object serviceObject = this.serviceObjectMap.get(serviceKey);
            if (serviceObject == null) {
                Map<String, Object> map = this.serviceObjectMap;
                synchronized (map) {
                    serviceObject = this.serviceObjectMap.get(serviceKey);
                    if (serviceObject == null) {
                        if (resourceName.contains(".")) {
                            try {
                                serviceObject = Class.forName(resourceName).newInstance();
                            }
                            catch (Exception e) {
                                log.error("New Instance ERROR! resourceName: ", (Object)resourceName);
                                serviceObject = null;
                            }
                        }
                        if (serviceObject == null) {
                            Class factory = TypesContainer.getOrRegister((String)appServiceFactory);
                            serviceObject = factory.getMethod("getService", String.class).invoke(null, resourceName);
                        }
                        this.serviceObjectMap.put(serviceKey, serviceObject);
                    }
                }
            }
            if ((serviceMethod = this.findServiceMethod(serviceObject.getClass(), tccMethod.getName(), tccMethod.getMethodParamCount())).getParameterCount() == 2) {
                result = serviceMethod.invoke(serviceObject, paramObject, this.getLastReturn(branchInvokerParam));
            } else {
                serviceMethod.invoke(serviceObject, paramObject);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            this.setResponseError(e);
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1%1$s.%2$s\u7684\u65b9\u6cd5%3$s\u5931\u8d25:%4$s", (String)"KdtxDispatchServiceImpl_0", (String)"bos-kdtx-sdk", (Object[])new Object[0]), Instance.getAppName(), resourceName, tccMethod, e.getMessage());
            throw new KdtxException(msg, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1%1$s.%2$s\u7684\u65b9\u6cd5%3$s\u5931\u8d25:%4$s", (String)"KdtxDispatchServiceImpl_0", (String)"bos-kdtx-sdk", (Object[])new Object[0]), Instance.getAppName(), resourceName, tccMethod, e.getTargetException().getMessage());
            this.setResponseError(e);
            throw new BranchBizException(msg, e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            throw new KdtxException("kdtx branch invoker class not found error", (Throwable)e);
        }
        return result;
    }

    private Object getBizParam(BranchInvokerParam branchInvokerParam) throws ClassNotFoundException {
        Object bizParam = null;
        if (StringUtils.isNotEmpty((String)branchInvokerParam.getParamType())) {
            byte[] paramBytes = branchInvokerParam.getParasBytes();
            if (paramBytes != null && paramBytes.length > 0) {
                bizParam = JsonUtils.deSerialization((byte[])paramBytes);
            } else {
                Class<?> paramClz = Class.forName(branchInvokerParam.getParamType());
                bizParam = JsonUtils.parseJson((String)branchInvokerParam.getParamStr(), paramClz);
            }
        } else {
            String serializer = branchInvokerParam.getAttachment() != null ? branchInvokerParam.getAttachment().getSerializer() : null;
            bizParam = this.deserialize(branchInvokerParam.getParasBytes(), serializer);
        }
        return bizParam;
    }

    private Object getLastReturn(BranchInvokerParam branchInvokerParam) {
        byte[] lastReturn = branchInvokerParam.getLastReturn();
        if (lastReturn != null) {
            return JsonUtils.deSerialization((byte[])lastReturn);
        }
        return null;
    }

    private void setResponseError(Exception e) {
        if (e instanceof InvocationTargetException) {
            for (Throwable sube = ((InvocationTargetException)e).getTargetException(); sube != null; sube = sube.getCause()) {
                if (!(sube instanceof KDException)) continue;
                ResponseHeader.get().error(((KDException)sube).getErrorCode());
                return;
            }
        }
        ResponseHeader.get().error(new ErrorCode("mserviceInvoke/" + e.getClass().getSimpleName(), e.getMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method findServiceMethod(Class<?> clazz, String method, int paramterLength) {
        String key = clazz.getName() + '#' + method + '#' + paramterLength;
        Method serviceMethod = this.serviceMethodMap.get(key);
        if (serviceMethod == null) {
            Map<String, Method> map = this.serviceMethodMap;
            synchronized (map) {
                serviceMethod = this.serviceMethodMap.get(key);
                if (serviceMethod == null) {
                    for (Method m : clazz.getMethods()) {
                        if (!m.getName().equalsIgnoreCase(method) || m.getParameterCount() != paramterLength) continue;
                        serviceMethod = m;
                        this.serviceMethodMap.put(key, serviceMethod);
                        break;
                    }
                }
            }
            if (serviceMethod == null) {
                throw new KDException(new ErrorCode("###", ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u7c7b%1$s\u7684\u65b9\u6cd5%2$s", (String)"KdtxDispatchServiceImpl_1", (String)"bos-kdtx-sdk", (Object[])new Object[0])), new Object[]{clazz.getName(), method});
            }
        }
        return serviceMethod;
    }

    private Object deserialize(byte[] param, String serializerStr) {
        if (param == null || param.length == 0) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)serializerStr)) {
            try {
                KdtxSerializer serializer = (KdtxSerializer)Class.forName(serializerStr).newInstance();
                return serializer.deserialize(param);
            }
            catch (Exception e) {
                throw new KdtxException("deserialize error", (Throwable)e);
            }
        }
        return JsonUtils.deSerialization((byte[])param);
    }
}

