/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session;

import java.util.List;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.context.DtxContext;
import kd.bos.kdtx.common.entity.CallbackInfo;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.invoke.TxInvoker;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.exception.ExceptionUtil;
import kd.bos.kdtx.sdk.init.TableInitConfig;
import kd.bos.kdtx.sdk.session.ListenSession;
import kd.bos.kdtx.sdk.session.Session;
import kd.bos.kdtx.sdk.tm.TransactionManager;
import kd.bos.kdtx.sdk.tm.TransactionManagerHolder;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractSession
extends ListenSession
implements Session {
    private DtxType dtxType;
    private String scenesCode;
    private boolean asyncCommit;
    private boolean asyncRollback;
    private boolean runMqModel;
    protected DBRoute dbRoute;

    @Override
    @SdkInternal
    public void begin() {
        this.assertDtxNotExist();
    }

    @SdkInternal
    public void begin(boolean isReentrant) {
        if (!isReentrant) {
            this.assertDtxNotExist();
        }
    }

    @SdkInternal
    protected void doBegin() throws BeginDtxException {
        String parentXid = KdtxRequestContext.get().getXid();
        if (KdtxRequestContext.get().isFirst()) {
            try {
                TableInitConfig.initLocalTable(this.dtxType.getCode(), this.dbRoute);
                if (this.dtxType == DtxType.TCC && this.dbRoute != null) {
                    DtxContext.setDbRoute((String)this.dbRoute.getRouteKey());
                }
                DtxContext.setTxCode((String)this.getScenesCode());
                DtxContext.setTxType((String)Integer.toString(this.getDtxType().getCode()));
                if (DtxConfig.canRunMqMode((boolean)this.isRunMqModel())) {
                    DtxContext.setRunMqModel((boolean)this.isRunMqModel());
                }
                this.getTm().begin();
                KdtxRequestContext.get().setFirst(false);
            }
            catch (Exception e) {
                String newXid = KdtxRequestContext.get().getXid();
                if (newXid != null && !newXid.equals(parentXid)) {
                    KdtxRequestContext.popDealedTx((String)newXid);
                }
                throw ExceptionUtil.wrapBeginExcpetion(e);
            }
            finally {
                DtxContext.remove();
            }
        }
    }

    @Override
    public void commit() {
        try {
            this.commit(true);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapCommintExcpetion(e);
        }
    }

    public void commit(boolean asyncCommit) {
        try {
            this.setAsyncCommit(asyncCommit);
            this.resetContextForNestChildBegin();
            this.doCommit();
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapCommintExcpetion(e);
        }
    }

    @SdkInternal
    protected abstract void doCommit() throws Exception;

    @Override
    public void rollback() {
        this.rollback(true);
    }

    public void rollback(boolean asyncRollback) {
        try {
            this.assertDtxExist();
        }
        catch (Exception e) {
            ExceptionLogger.error(AbstractSession.class, (String)"KdtxMonitorLog xid is null when rollbacking", (Throwable)e);
            return;
        }
        this.setAsyncRollback(asyncRollback);
        try {
            if (DtxConfig.canRunMqMode((boolean)this.isRunMqModel())) {
                DtxContext.setRunMqModel((boolean)this.isRunMqModel());
            }
            this.resetContextForNestChildBegin();
            this.doRollback();
        }
        catch (Exception e) {
            throw ExceptionUtil.wrapRollBackExcpetion(e);
        }
    }

    @SdkInternal
    protected abstract void doRollback() throws Exception;

    @SdkInternal
    protected void assertDtxNotExist() {
        if (!KdtxRequestContext.get().isCommitted()) {
            throw new BeginDtxException(DtxErrorCodeConstants.DTX_NOT_REPEAT_BEGIN);
        }
    }

    @SdkInternal
    protected void assertDtxExist() {
        String xid = KdtxRequestContext.get().getXid();
        if (xid == null) {
            throw new KdtxException(DtxErrorCodeConstants.XID_EMPTY);
        }
    }

    @SdkInternal
    protected TransactionManager getTm() {
        return TransactionManagerHolder.get();
    }

    public String getScenesCode() {
        return this.scenesCode;
    }

    @SdkInternal
    public void setScenesCode(String scenesCode) {
        this.scenesCode = scenesCode;
    }

    @SdkInternal
    public DtxType getDtxType() {
        return this.dtxType;
    }

    @SdkInternal
    public void setDtxType(DtxType dtxType) {
        this.dtxType = dtxType;
    }

    @SdkInternal
    public boolean isAsyncCommit() {
        return this.asyncCommit;
    }

    @SdkInternal
    public void setAsyncCommit(boolean asyncCommit) {
        this.asyncCommit = asyncCommit;
        DtxContext.setAsyncCommit((boolean)asyncCommit);
    }

    @SdkInternal
    public boolean isAsyncRollback() {
        return this.asyncRollback;
    }

    @SdkInternal
    public void setAsyncRollback(boolean asyncRollback) {
        this.asyncRollback = asyncRollback;
        DtxContext.setAsyncRollback((boolean)asyncRollback);
    }

    @SdkInternal
    public boolean isRunMqModel() {
        return this.runMqModel;
    }

    @SdkInternal
    public void setRunMqModel(boolean runMqModel) {
        this.runMqModel = runMqModel;
    }

    public DBRoute getDbRoute() {
        return this.dbRoute;
    }

    public void setDbRoute(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    @SdkInternal
    public final void setCallback(String appId, DTXCallback dtxCallback) {
        String xid = KdtxRequestContext.get().getXid();
        String className = dtxCallback.getClass().getName();
        if (StringUtils.isEmpty((String)appId)) {
            throw new KdtxException("appId required");
        }
        if (dtxCallback == null) {
            throw new KdtxException("dtxCallback function required");
        }
        if (StringUtils.isEmpty((String)xid)) {
            throw new KdtxException("kdtx has not begin,pls registry or try first");
        }
        if (className.contains("$Lambda$")) {
            throw new KdtxException("don't support lambda express");
        }
        String simpleName = dtxCallback.getClass().getSimpleName();
        String lastClassName = className.substring(className.lastIndexOf(".") + 1);
        CallbackInfo callbackInfo = new CallbackInfo();
        callbackInfo.setAppId(appId);
        callbackInfo.setClassName(dtxCallback.getClass().getName());
        callbackInfo.setInnerClass(!simpleName.equals(lastClassName));
        TxInvoker.callbackCache.put(xid, callbackInfo);
    }

    @SdkInternal
    public static String covert2Str(List<String> bizIds) {
        String rs;
        StringBuilder ids = new StringBuilder();
        if (bizIds != null && bizIds.size() > 0) {
            for (int i = 0; i < bizIds.size(); ++i) {
                ids.append(bizIds.get(i));
                if (i == bizIds.size() - 1) continue;
                ids.append(",");
            }
        }
        if ((rs = ids.toString()).length() >= 100) {
            rs = rs.substring(0, 100);
        }
        return rs;
    }

    private void resetContextForNestChildBegin() {
        KdtxRequestContext.get().setCommitted(true);
        KdtxRequestContext.get().setFirst(true);
    }
}

