/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session;

import java.util.Stack;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.TxActionType;
import kd.bos.kdtx.common.entity.KdtxSuspendInfo;
import kd.bos.kdtx.common.util.KdtxSuspendProxy;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.context.TCCContext;
import kd.bos.kdtx.sdk.session.AbstractSession;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.kdtx.sdk.session.tcc.TCCSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ParentSession {
    private static final Log logger = LogFactory.getLog(ParentSession.class);

    public void suspend() {
        AbstractSession session = (AbstractSession)this;
        KdtxSuspendInfo suspendInfo = new KdtxSuspendInfo();
        suspendInfo.setDtxType(session.getDtxType().getCode());
        suspendInfo.setXid(KdtxRequestContext.get().getXid());
        suspendInfo.setScenesCode(session.getScenesCode());
        suspendInfo.setRouteKey(session.getDbRoute().getRouteKey());
        suspendInfo.setRunMqModel(session.isRunMqModel());
        suspendInfo.setAsyncCommit(session.isAsyncCommit());
        suspendInfo.setAsyncRollback(session.isAsyncRollback());
        KdtxSuspendProxy.addWaitCommit((Long)TX.__getTXContext().id(), (KdtxSuspendInfo)suspendInfo);
        DtxContext.remove();
        TCCContext.remove();
        KdtxRequestContext.get().setCommitted(true);
        KdtxRequestContext.get().setFirst(true);
    }

    public void resume(Long dbTxId, TxActionType txActionType) throws Exception {
        Stack waitCommitSet = KdtxSuspendProxy.getWaitCommitInfo((Long)dbTxId);
        if (waitCommitSet != null) {
            while (!waitCommitSet.empty()) {
                KdtxSuspendInfo kdtxSuspendInfo = (KdtxSuspendInfo)waitCommitSet.pop();
                KdtxRequestContext.get().decrWaitCommitSize();
                int dtxType = kdtxSuspendInfo.getDtxType();
                String scenesCode = kdtxSuspendInfo.getScenesCode();
                DBRoute route = DBRoute.of((String)kdtxSuspendInfo.getRouteKey());
                boolean isMQ = kdtxSuspendInfo.isRunMqModel();
                boolean asyncCommit = kdtxSuspendInfo.isAsyncCommit();
                if (dtxType == DtxType.EC.getCode()) {
                    ECSession ecSession = DtxFactory.createEC(scenesCode);
                    ecSession.setDbRoute(route);
                    ecSession.setRunMqModel(isMQ);
                    if (txActionType == TxActionType.COMMIT) {
                        ecSession.commit(asyncCommit);
                        continue;
                    }
                    ecSession.rollback(asyncCommit);
                    continue;
                }
                if (dtxType != DtxType.TCC.getCode()) continue;
                TCCSession tccSession = DtxFactory.createTCC(scenesCode);
                tccSession.setDbRoute(route);
                if (txActionType == TxActionType.COMMIT) {
                    tccSession.commit(asyncCommit);
                    continue;
                }
                tccSession.rollback(asyncCommit);
            }
        }
    }
}

