/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session.tcc;

import java.util.List;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.exception.TCCTryException;
import kd.bos.kdtx.common.util.AssertUtils;
import kd.bos.kdtx.sdk.api.DTXCallback;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.context.TCCContext;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.exception.RegisterDtxException;
import kd.bos.kdtx.sdk.session.AbstractSession;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ListenSession;
import kd.bos.kdtx.sdk.session.tcc.TCCSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TCCGlobalSession {
    private static final Log logger = LogFactory.getLog(TCCGlobalSession.class);
    public static final String TCC_GLOBAL_MUST_IN_LOCAL_TX = "KdtxMonitorLog TCC Global must in local TX.";
    public static final String LOCAL_TX_IS_NOT_SUPPORTED = "KdtxMonitorLog local TX is NOT SUPPORTED";
    public static final String DIFFERENT_DTX_TYPE_FOUND = "KdtxMonitorLog different dtx type found";
    public static final String DIFFERENT_LOCAL_TXID_FOUND = "KdtxMonitorLog different local txid found";
    public static final String ROUTEKEY_IS_EMPTY = "KdtxMonitorLog local TX is null or writtenRouteKey is empty.";
    public static final String TCC_SESSION_TRY_ERROR = "KdtxMonitorLog tcc session try error.";

    public static void begin(String scenesCode, DBRoute dbRoute, boolean isReentrant) {
        TCCSession tccSession = null;
        if (isReentrant) {
            tccSession = TCCContext.getTCCSession();
        }
        if (tccSession == null) {
            AssertUtils.assertTrueAndLog((boolean)StringUtils.isNotEmpty((String)scenesCode), (String)"KdtxMonitorLog TCCGlobalSession begin error, scenesCode is empty", (RuntimeException)new BeginDtxException(DtxErrorCodeConstants.TXCODE_EMPTY));
            tccSession = DtxFactory.createTCC(scenesCode);
            tccSession.setDbRoute(dbRoute);
            tccSession.setAsyncCommit(true);
            tccSession.setAsyncCommit(true);
        }
        tccSession.begin(isReentrant);
        TCCContext.setTCCSession(tccSession);
    }

    @SdkInternal
    public static void begin(String scenesCode, DBRoute dbRoute, GlobalSessionType sessionType) {
        boolean isReentrant = false;
        if (sessionType == GlobalSessionType.COMBINATION && !KdtxRequestContext.get().isCommitted()) {
            AbstractSession session = (AbstractSession)ListenSession.getCurrentSession();
            if (session != null) {
                session.suspend();
            }
        } else if (sessionType == GlobalSessionType.REENTRANT) {
            isReentrant = true;
        } else if (sessionType == GlobalSessionType.NEW_BUILD) {
            isReentrant = false;
        }
        TCCGlobalSession.begin(scenesCode, dbRoute, isReentrant);
    }

    public static void Try(String scenesCode, String cloudId, String appId, String serviceName, Param param, String branchScenesCode, DBRoute dbRoute, List<String> bizIds) throws TCCTryException {
        TCCSession tccSession;
        int dtxType = KdtxRequestContext.get().getDtxType();
        AssertUtils.assertTrueAndLog((boolean)TX.inTX(), (String)TCC_GLOBAL_MUST_IN_LOCAL_TX, (TCCTryException)new TCCTryException(TCC_GLOBAL_MUST_IN_LOCAL_TX));
        AssertUtils.assertTrueAndLog((TX.getPropagation() != Propagation.NOT_SUPPORTED ? 1 : 0) != 0, (String)LOCAL_TX_IS_NOT_SUPPORTED, (TCCTryException)new TCCTryException(LOCAL_TX_IS_NOT_SUPPORTED));
        if (!KdtxRequestContext.get().isCommitted()) {
            AssertUtils.assertTrueAndLog((dtxType == DtxType.TCC.getCode() ? 1 : 0) != 0, (String)DIFFERENT_DTX_TYPE_FOUND, (TCCTryException)new TCCTryException(DIFFERENT_DTX_TYPE_FOUND));
            long localTxIdContext = KdtxRequestContext.get().getLocalTxId();
            AssertUtils.assertTrueAndLog((TX.__getTXContext().id() == localTxIdContext ? 1 : 0) != 0, (String)DIFFERENT_LOCAL_TXID_FOUND, (TCCTryException)new TCCTryException(DIFFERENT_LOCAL_TXID_FOUND));
        }
        if ((tccSession = TCCContext.getTCCSession()) == null) {
            TCCGlobalSession.begin(scenesCode, dbRoute, false);
            tccSession = TCCContext.getTCCSession();
        }
        DBRoute routeKey = StringUtils.isNotEmpty((String)TX.getWrittenRouteKey()) ? DBRoute.of((String)TX.getWrittenRouteKey()) : tccSession.getDbRoute();
        AssertUtils.assertTrueAndLog((routeKey != null ? 1 : 0) != 0, (String)ROUTEKEY_IS_EMPTY, (TCCTryException)new TCCTryException(ROUTEKEY_IS_EMPTY));
        tccSession.setDbRoute(routeKey);
        try {
            tccSession.Try(cloudId, appId, serviceName, param, branchScenesCode, bizIds);
        }
        catch (Exception e) {
            logger.error(TCC_SESSION_TRY_ERROR, (Throwable)e);
            throw new TCCTryException(TCC_SESSION_TRY_ERROR + e.getMessage(), e);
        }
    }

    public static void Try(String scenesCode, String cloudId, String appId, String serviceName, Param param, String branchScenesCode, DBRoute dbRoute) throws TCCTryException {
        TCCGlobalSession.Try(scenesCode, cloudId, appId, serviceName, param, branchScenesCode, dbRoute, null);
    }

    public static void Try(String scenesCode, String cloudId, String appId, String serviceName, Param param, String branchScenesCode) throws TCCTryException {
        TCCGlobalSession.Try(scenesCode, cloudId, appId, serviceName, param, branchScenesCode, null);
    }

    public static void Try(String cloudId, String appId, String serviceName, Param param, String branchScenesCode) throws TCCTryException {
        TCCGlobalSession.Try(null, cloudId, appId, serviceName, param, branchScenesCode, null);
    }

    public static void Try(String scenesCode, String cloudId, String appId, String serviceName) throws TCCTryException {
        TCCGlobalSession.Try(scenesCode, cloudId, appId, serviceName, null, null, null);
    }

    public static void Try(String cloudId, String appId, String serviceName) throws TCCTryException {
        TCCGlobalSession.Try(cloudId, appId, serviceName, null, null);
    }

    public static void setCallback(String appId, DTXCallback dtxCallback) {
        TCCSession tccSession = TCCContext.getTCCSession();
        if (tccSession == null) {
            throw new KdtxException("NOT IN TCC CONTEXT");
        }
        tccSession.setCallback(appId, dtxCallback);
    }

    public static void lock(List<String> businessIds) {
        TCCSession session = TCCContext.getTCCSession();
        if (session == null) {
            String msg = "TCCSession from TCCContext is empty.";
            logger.error(msg);
            throw new KdtxException(msg);
        }
        session.lock(businessIds);
    }

    public static void setAsync(boolean async) throws KDException {
        TCCSession session = TCCContext.getTCCSession();
        AssertUtils.assertTrueAndLog((session != null ? 1 : 0) != 0, (String)"TCCSession is null,please begin first.", (RuntimeException)new RegisterDtxException(DtxErrorCodeConstants.SESSION_EMPTY));
        TCCSession tccSession = session;
        tccSession.setAsyncCommit(async);
        tccSession.setAsyncRollback(async);
    }
}

