/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.session.tcc;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.context.DtxContext;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.localtx.TccLocalTxDbHelper;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.sdk.session.AbstractSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class TCCSession
extends AbstractSession {
    private static Set<String> tccXids;
    private static final Log log;

    public TCCSession() {
        this.setDtxType(DtxType.TCC);
    }

    @Override
    protected void doRollback() throws Exception {
        String curDealXid = KdtxRequestContext.get().getXid();
        if (curDealXid == null) {
            log.warn("TCCSession doRollback error,xid is null!!!");
            return;
        }
        if (tccXids.remove(curDealXid)) {
            try {
                this.getTm().txRollback();
            }
            finally {
                KdtxRequestContext.popDealedTx((String)curDealXid);
            }
        }
    }

    @Override
    @SdkInternal
    protected void doCommit() throws Exception {
        String curDealXid = KdtxRequestContext.get().getXid();
        if (curDealXid == null) {
            log.warn("TCCSession doCommit error,xid is null!!!");
            return;
        }
        if (tccXids.remove(curDealXid)) {
            try {
                this.getTm().txCommit();
            }
            finally {
                KdtxRequestContext.popDealedTx((String)curDealXid);
                DtxContext.remove();
            }
        }
    }

    public void Try(String cloudId, String appId, String serviceName, Param param, String branchScenesCode, List<String> bizIds) throws Exception {
        KdtxRequestContext.get().setCommitted(false);
        DtxParas tccParas = new DtxParas();
        String parentBranchId = KdtxRequestContext.get().getBranchId();
        try {
            this.doBegin();
            this.assertDtxExist();
            this.addCommitListener();
            String bizId = TCCSession.covert2Str(bizIds);
            tccParas.setAppId(appId);
            tccParas.setCloudId(cloudId);
            tccParas.setResource(serviceName);
            tccParas.setBizId(bizId);
            if (param != null) {
                tccParas.setParamType("");
                tccParas.setParam("");
                tccParas.setParasBytes(JsonUtils.serialization((Object)param));
            }
            DtxContext.setTxCode((String)this.getScenesCode());
            DtxContext.setBranchCode((String)branchScenesCode);
            if (KdtxRequestContext.get().getXid() == null) {
                throw new KdtxException(DtxErrorCodeConstants.XID_EMPTY);
            }
            if (tccXids.add(KdtxRequestContext.get().getXid()) && TX.inTX()) {
                TccLocalTxDbHelper.insertTCCTable((String)KdtxRequestContext.get().getXid(), (DBRoute)this.dbRoute);
            }
            this.getTm().branchRegister(tccParas);
            if (param != null) {
                tccParas.setParasBytes(JsonUtils.serialization((Object)param));
            }
            this.getTm().branchTry(tccParas);
        }
        catch (Exception e) {
            KdtxRequestContext.get().setCommitted(true);
            KdtxRequestContext.get().setFirst(true);
            ExceptionLogger.error(TCCSession.class, (String)("KdtxMonitorLog prepare fail paras: " + JSONUtils.toString((Object)tccParas) + " branchId: " + KdtxRequestContext.get().getBranchId()), (Throwable)e);
            throw e;
        }
        finally {
            KdtxRequestContext.get().setBranchId(parentBranchId);
            DtxContext.remove();
        }
    }

    public void Try(String cloudId, String appId, String serviceName, Param param, String branchScenesCode) throws Exception {
        this.Try(cloudId, appId, serviceName, param, branchScenesCode, null);
    }

    public void Try(String cloudId, String appId, String serviceName, Param param) throws Exception {
        this.Try(cloudId, appId, serviceName, param, null);
    }

    public void Try(String cloudId, String appId, String serviceName, String branchScenesCode) throws Exception {
        this.Try(cloudId, appId, serviceName, null, branchScenesCode);
    }

    public void Try(String cloudId, String appId, String serviceName) throws Exception {
        this.Try(cloudId, appId, serviceName, null, null);
    }

    public void lock(List<String> businessIds) throws KdtxException {
        if (CollectionUtils.isEmpty(businessIds)) {
            throw new KdtxException("TCC: param businessIds can not be null or empty");
        }
        DtxContext.setBusinessIds(businessIds);
        if (StringUtils.isNotEmpty((String)KdtxRequestContext.get().getXid())) {
            try {
                this.getTm().setBusinessInfo();
            }
            catch (Exception e) {
                throw new KdtxException("setBusinessInfo error:", (Throwable)e);
            }
            finally {
                DtxContext.remove();
            }
            return;
        }
    }

    static {
        new ConcurrentHashMap(8);
        tccXids = ConcurrentHashMap.newKeySet();
        log = LogFactory.getLog(TCCSession.class);
    }
}

