/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.sdk.tm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.KdtxRequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.ActionType;
import kd.bos.kdtx.common.constant.BranchStatus;
import kd.bos.kdtx.common.constant.InvokeType;
import kd.bos.kdtx.common.constant.Status;
import kd.bos.kdtx.common.entity.TxBranchInfo;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.common.invoke.factory.InvokerFactory;
import kd.bos.kdtx.common.log.DBLogger;
import kd.bos.kdtx.common.log.MultiDBWriteHandler;
import kd.bos.kdtx.common.util.EnumUtils;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.sdk.entity.BranchParam;
import kd.bos.kdtx.sdk.exception.CommitDtxException;
import kd.bos.kdtx.sdk.exception.RegisterDtxException;
import kd.bos.kdtx.sdk.tm.TransactionManagerHolder;
import kd.bos.util.StringUtils;

public class CascadeInvokeManager {
    private static final BranchStatus[] PCC_STATUS = new BranchStatus[]{BranchStatus.PREPARING, BranchStatus.COMMIT_FAILED, BranchStatus.COMMITTING};
    private static final BranchStatus[] UPDATE_DISCARD_STATUS = new BranchStatus[]{BranchStatus.PREPARING, BranchStatus.COMMITTED, BranchStatus.COMMIT_FAILED, BranchStatus.COMMITTING, BranchStatus.ROLLBACK_FAILED, BranchStatus.ROLLBACKED, BranchStatus.ROLLBACKING};
    private static final BranchStatus[] COMMITTING_STATUS = new BranchStatus[]{BranchStatus.COMMITTING};
    private static final BranchStatus[] COMMIT_FAILED_STATUS = new BranchStatus[]{BranchStatus.COMMIT_FAILED};

    public static final Object invokeCascade(BranchParam param, Long cascadeSeq) throws Exception {
        DtxResponse response;
        String currentBranchId;
        String xid = KdtxRequestContext.get().getXid();
        String parentBranchId = KdtxRequestContext.get().getBranchId();
        List<TxBranchInfo> branchInfos = CascadeInvokeManager.getBranchInfo(xid, null, null, null);
        CascadeInvokeManager.check(param, cascadeSeq, branchInfos);
        DtxParas dtxParas = CascadeInvokeManager.buildParam(param, xid, parentBranchId, cascadeSeq);
        dtxParas.setParasBytes(JsonUtils.serialization((Object)param.getParam()));
        TxBranchInfo branchInfo = CascadeInvokeManager.getCurrentBranch(branchInfos, parentBranchId, cascadeSeq);
        int triggerType = 1;
        try {
            if (branchInfo != null) {
                CascadeInvokeManager.updateCascadeBranch(String.valueOf(branchInfo.getBranchId()), param, xid);
                triggerType = 3;
            }
            dtxParas.setSeq(CascadeInvokeManager.getSeq(xid));
            TransactionManagerHolder.get().registerCascadeBranch(dtxParas);
            currentBranchId = KdtxRequestContext.get().getBranchId();
        }
        catch (Exception e) {
            throw new RegisterDtxException(e, DtxErrorCodeConstants.CASCADE_REGISTER_ERROR);
        }
        long logId = 0L;
        int result = 1;
        String remark = "";
        try {
            CascadeInvokeManager.setCurrentBranchIdInContext(currentBranchId);
            CascadeInvokeManager.updateBranch(xid, currentBranchId, BranchStatus.COMMITTING, null, PCC_STATUS);
            logId = DBLogger.insertActionLog((String)xid, (ActionType)ActionType.CASCADE_BRANCH_COMMIT, (String)currentBranchId, (int)triggerType);
            response = (DtxResponse)InvokerFactory.getTCCInvoker((InvokeType)InvokeType.BRANCH_COMMIT).doInvoke(dtxParas);
            String lastReturn = null;
            if (response != null) {
                lastReturn = response.toJsonString();
            }
            CascadeInvokeManager.updateBranch(xid, currentBranchId, BranchStatus.COMMITTED, lastReturn, COMMITTING_STATUS);
        }
        catch (Exception e) {
            CascadeInvokeManager.updateBranch(xid, currentBranchId, BranchStatus.COMMIT_FAILED, null, COMMITTING_STATUS);
            remark = e.getMessage();
            result = -1;
            throw new CommitDtxException(e, DtxErrorCodeConstants.CASCADE_REGISTER_ERROR);
        }
        finally {
            CascadeInvokeManager.setCurrentBranchIdInContext(parentBranchId);
            DBLogger.updateActionLog((String)xid, (String)currentBranchId, (long)logId, (ActionType)ActionType.CASCADE_BRANCH_COMMIT, (int)result, (String)remark);
        }
        return response;
    }

    private static void updateCascadeBranch(String currentBranchId, BranchParam param, String xid) throws Exception {
        List<TxBranchInfo> faildCascadeBranchs = CascadeInvokeManager.getBranchInfo(xid, currentBranchId, null, null);
        if (faildCascadeBranchs != null && faildCascadeBranchs.size() > 0) {
            CascadeInvokeManager.updateCascadeBranch(xid, currentBranchId, BranchStatus.DISCARD);
        }
    }

    private static void check(BranchParam param, Long cascadeSeq, List<TxBranchInfo> branchInfos) {
        if (StringUtils.isEmpty((String)KdtxRequestContext.get().getXid())) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_XID_EMPTY);
        }
        if (StringUtils.isEmpty((String)param.getCloudId())) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_CLOUDID_EMPTY);
        }
        if (StringUtils.isEmpty((String)param.getAppId())) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_APPID_EMPTY);
        }
        if (StringUtils.isEmpty((String)KdtxRequestContext.get().getBranchId())) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_PARENTBRANCHID_EMPTY);
        }
        if (StringUtils.isEmpty((String)param.getServiceName())) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_SERVICENAME_EMPTY);
        }
        ArrayList<TxBranchInfo> cascadeBranchs = new ArrayList<TxBranchInfo>();
        HashMap<String, TxBranchInfo> allBranch = new HashMap<String, TxBranchInfo>(branchInfos.size());
        for (TxBranchInfo branchInfo : branchInfos) {
            if (KdtxRequestContext.get().getBranchId().equals(branchInfo.getParentBranchId())) {
                cascadeBranchs.add(branchInfo);
            }
            allBranch.put(branchInfo.getBranchId(), branchInfo);
        }
        int levelSize = CascadeInvokeManager.buildBranchLevel(KdtxRequestContext.get().getBranchId(), allBranch);
        if (levelSize > DtxConfig.getCascadeLevel() - 1) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_LEVEL_ERROR);
        }
        if (cascadeSeq == 0L) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_CASCADESEQ_START_ERROR);
        }
        Long maxCascadSeq = 1L;
        for (TxBranchInfo branchInfo : cascadeBranchs) {
            if (branchInfo.getBranchStatus() == 8) continue;
            if (cascadeSeq.longValue() == branchInfo.getCascadeSeq()) {
                throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_CASCADESEQ_SAME_ERROR);
            }
            if (branchInfo.getCascadeSeq() <= maxCascadSeq) continue;
            maxCascadSeq = branchInfo.getCascadeSeq();
        }
        if (cascadeSeq < maxCascadSeq) {
            throw new RegisterDtxException(DtxErrorCodeConstants.INVOKE_CASCADE_CASCADESEQ_LESS_ERROR);
        }
    }

    private static int buildBranchLevel(String parentBranchId, Map<String, TxBranchInfo> allBranch) {
        TxBranchInfo branchInfo;
        HashSet<String> branchIds = new HashSet<String>();
        branchIds.add(parentBranchId);
        while ((branchInfo = allBranch.get(parentBranchId)) != null) {
            parentBranchId = branchInfo.getParentBranchId();
            if (StringUtils.isNotEmpty((String)parentBranchId)) {
                branchIds.add(parentBranchId);
                continue;
            }
            branchIds.add(branchInfo.getBranchId());
            break;
        }
        return branchIds.size();
    }

    private static DtxParas buildParam(BranchParam param, String xid, String parentBranchId, Long cascadeSeq) {
        DtxParas tccParas = new DtxParas();
        if (StringUtils.isEmpty((String)xid)) {
            xid = KdtxRequestContext.get().getXid();
        }
        if (StringUtils.isEmpty((String)parentBranchId)) {
            parentBranchId = KdtxRequestContext.get().getBranchId();
        }
        tccParas.setCloudId(param.getCloudId());
        tccParas.setAppId(param.getAppId());
        tccParas.setResource(param.getServiceName());
        tccParas.setBizId(param.getBizId());
        tccParas.setXid(xid);
        tccParas.setParentBranchId(parentBranchId == null ? "" : parentBranchId);
        tccParas.setCascadeSeq(cascadeSeq);
        Param params = param.getParam();
        if (params != null) {
            tccParas.setParamType(params.getClass().getName());
            tccParas.setParam(JsonUtils.getParasStr((Object)params));
        }
        return tccParas;
    }

    private static DtxResponse buildResponse(String result) {
        return null;
    }

    private static boolean updateBranch(String xid, String branchId, BranchStatus branchStatus, String result, BranchStatus[] originalStatuses) throws Exception {
        if (originalStatuses == null || originalStatuses.length == 0) {
            ExceptionLogger.error(CascadeInvokeManager.class, (String)"KdtxMonitorLog originalStatuses is empty!");
            throw new KdtxException();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(branchStatus.getCode());
        if (result != null) {
            paramList.add(result);
        }
        paramList.add(xid);
        paramList.add(branchId);
        Object[] params = paramList.toArray();
        String sql = "UPDATE t_cbs_dtx_branch SET fstatus = ?, ";
        if (result != null) {
            sql = sql + "fresult = ?, ";
        }
        sql = sql + "fupdate_time = NOW() WHERE fxid = ? AND fbranch_id =? AND fstatus in ( %s )";
        String endSql = sql = String.format(sql, EnumUtils.toString((Status[])originalStatuses));
        return (Integer)MultiDBWriteHandler.execute(() -> DB.update((DBRoute)DBRoute.base, (String)endSql, (Object[])params)) == 1;
    }

    private static boolean updateCascadeBranch(String xid, String parentBranchId, BranchStatus branchStatus) throws Exception {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(branchStatus.getCode());
        paramList.add(xid);
        paramList.add(parentBranchId);
        Object[] params = paramList.toArray();
        String sql = "UPDATE t_cbs_dtx_branch SET fstatus = ?, fupdate_time = NOW() WHERE fxid = ? AND fparent_branch_id =? ";
        return (Integer)MultiDBWriteHandler.execute(() -> DB.update((DBRoute)DBRoute.base, (String)sql, (Object[])params)) == 1;
    }

    private static List<TxBranchInfo> getBranchInfo(String xid, String parentBranchId, Long cascadeSeq, BranchStatus[] originalStatuses) {
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(xid);
        String sql = "SELECT fresource, fparas, fid, fstatus, fbranch_id, fseq ,fxid ,fparent_branch_id,fchild_seq FROM t_cbs_dtx_branch WHERE fxid = ? ";
        String orderby = " ORDER BY fseq ASC ";
        if (!StringUtils.isEmpty((String)parentBranchId)) {
            paramsList.add(parentBranchId);
            sql = sql + " and fparent_branch_id = ? ";
        }
        if (cascadeSeq != null) {
            paramsList.add(cascadeSeq);
            sql = sql + " and fchild_seq = ? ";
        }
        if (originalStatuses != null && originalStatuses.length > 0) {
            String statusSql = " and fstatus in ( % ) ";
            statusSql = String.format(statusSql, EnumUtils.toString((Status[])originalStatuses));
            sql = sql + statusSql;
        }
        sql = sql + orderby;
        Object[] params = paramsList.toArray(new Object[paramsList.size()]);
        return (List)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, rs -> {
            ArrayList<TxBranchInfo> ret = new ArrayList<TxBranchInfo>(8);
            while (rs.next()) {
                TxBranchInfo txBranchInfo = new TxBranchInfo();
                txBranchInfo.setResource(rs.getString(1));
                txBranchInfo.setParas(rs.getString(2));
                txBranchInfo.setId(rs.getLong(3));
                txBranchInfo.setBranchStatus(rs.getInt(4));
                txBranchInfo.setBranchId(rs.getString(5));
                txBranchInfo.setSeq(rs.getLong(6));
                txBranchInfo.setXid(rs.getString(7));
                txBranchInfo.setParentBranchId(rs.getString(8));
                txBranchInfo.setCascadeSeq(rs.getLong(9));
                ret.add(txBranchInfo);
            }
            return ret;
        });
    }

    private static long getSeq(String xid) {
        String seqSql = "SELECT CASE WHEN (COUNT(1) = 0) THEN 0 ELSE MAX(fseq) + 1 END FROM t_cbs_dtx_branch WHERE fxid = ? ";
        Object[] seqParams = new Object[]{xid};
        return (Long)DB.query((DBRoute)DBRoute.base, (String)seqSql, (Object[])seqParams, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    private static void setCurrentBranchIdInContext(String branchId) {
        KdtxRequestContext.get().setBranchId(branchId);
    }

    private static TxBranchInfo getCurrentBranch(List<TxBranchInfo> branchInfos, String parentBranchId, Long cascadeSeq) {
        for (TxBranchInfo branchInfo : branchInfos) {
            if (branchInfo.getCascadeSeq() == 0L || branchInfo.getCascadeSeq() != cascadeSeq.longValue() || !StringUtils.isNotEmpty((String)branchInfo.getParentBranchId()) || !branchInfo.getParentBranchId().equals(parentBranchId)) continue;
            return branchInfo;
        }
        return null;
    }

    private static class BranchLevel {
        String branchId;
        String parentBranchId;
        List<BranchLevel> childLevel;

        private BranchLevel() {
        }

        public String getBranchId() {
            return this.branchId;
        }

        public void setBranchId(String branchId) {
            this.branchId = branchId;
        }

        public String getParentBranchId() {
            return this.parentBranchId;
        }

        public void setParentBranchId(String parentBranchId) {
            this.parentBranchId = parentBranchId;
        }

        public List<BranchLevel> getChildLevel() {
            return this.childLevel;
        }

        public void setChildLevel(List<BranchLevel> childLevel) {
            this.childLevel = childLevel;
        }
    }
}

