/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.archive.ArchiveInitService;
import kd.bos.framework.lifecycle.dlock.DLockCleanService;
import kd.bos.framework.lifecycle.sharding.ShardingInitService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.WebPortUtil;

public class SystemServiceConfig {
    private static Log log = LogFactory.getLog(SystemServiceConfig.class);
    private static String[] systemServiceClasses = null;
    private static Service[] services = null;
    private static Service[] allServices = null;
    private static String[] webSystemServiceClasses = null;
    private static Service[] webServices = null;
    private static String[] msSystemServiceClasses = null;
    private static Service[] msServices = null;

    public static Service[] getServices() {
        return services;
    }

    public static <T extends Service> T getService(Class<T> cls) {
        for (Service s : allServices) {
            if (!cls.isAssignableFrom(s.getClass())) continue;
            return (T)s;
        }
        return null;
    }

    private static void initService() {
        HashMap<String, Supplier<Service>> allServiceSupplierMap = new HashMap<String, Supplier<Service>>();
        Function<String, Supplier> createFunction = cls -> () -> SystemServiceConfig.createByClass(cls);
        for (String cls2 : systemServiceClasses) {
            allServiceSupplierMap.computeIfAbsent(cls2, createFunction);
        }
        for (String cls2 : webSystemServiceClasses) {
            allServiceSupplierMap.computeIfAbsent(cls2, createFunction);
        }
        for (String cls2 : msSystemServiceClasses) {
            allServiceSupplierMap.computeIfAbsent(cls2, createFunction);
        }
        ArrayList<Service> sysList = SystemServiceConfig.getServiceList(systemServiceClasses, allServiceSupplierMap);
        ArrayList<Service> weblist = new ArrayList<Service>();
        if (Instance.isWebMserviceInOne() || WebPortUtil.isWebNode()) {
            weblist.addAll(sysList);
            weblist.addAll(SystemServiceConfig.getServiceList(webSystemServiceClasses, allServiceSupplierMap));
        }
        ArrayList<Service> mslist = new ArrayList<Service>();
        if (Instance.isWebMserviceInOne() || !WebPortUtil.isWebNode()) {
            mslist.addAll(sysList);
            mslist.addAll(SystemServiceConfig.getServiceList(msSystemServiceClasses, allServiceSupplierMap));
        }
        services = sysList.toArray(new Service[sysList.size()]);
        webServices = weblist.toArray(new Service[weblist.size()]);
        msServices = mslist.toArray(new Service[mslist.size()]);
        ArrayList<Service> alllist = new ArrayList<Service>();
        alllist.addAll(mslist);
        for (Service webService : weblist) {
            if (alllist.indexOf(webService) != -1) continue;
            alllist.add(webService);
        }
        allServices = alllist.toArray(new Service[alllist.size()]);
    }

    public static Service[] getAllServices() {
        return allServices;
    }

    private static ArrayList<Service> getServiceList(String[] serviceClasses, Map<String, Supplier<Service>> allServiceSupplierMap) {
        ArrayList<Service> list = new ArrayList<Service>(serviceClasses.length);
        for (String cls : serviceClasses) {
            list.add(allServiceSupplierMap.get(cls).get());
        }
        return list;
    }

    public static Service[] getWebServices() {
        return webServices;
    }

    public static Service[] getMSServices() {
        return msServices;
    }

    private static Service createByClass(String className) {
        try {
            return (Service)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("Can't create service by " + className, (Throwable)e);
            throw new Error("Can't create service by " + className, e);
        }
    }

    static {
        systemServiceClasses = new String[]{"kd.bos.xcache.starter.XCacheService", "kd.bos.kdtx.sdk.service.KdtxClientRegisterService", "kd.bos.mq.init.MQService", "kd.bos.ha.HAService", "kd.bos.mservice.HealthService", "kd.bos.dts.service.DtsInitService", "kd.bos.kdtx.server.service.TCRegisterService", "kd.bos.kdtx.server.tasks.KdtxTaskService", "kd.bos.flydb.starter.FlyDBClientService", "kd.bos.pigeon.core.PigeonService"};
        webSystemServiceClasses = new String[]{"kd.bos.framework.lifecycle.services.SessionManagerService", "kd.bos.framework.lifecycle.services.MsgJetSubscribeService"};
        msSystemServiceClasses = new String[]{ShardingInitService.class.getName(), ArchiveInitService.class.getName(), DLockCleanService.class.getName(), "kd.bos.framework.lifecycle.appstart.AppStarterService", "kd.bos.framework.lifecycle.PreHeatService", "kd.bos.dts.service.DtsService", "kd.bos.framework.task.BackendTaskService", "kd.bos.framework.lifecycle.services.PermissionService"};
        SystemServiceConfig.initService();
    }
}

