/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.collection;

import java.lang.reflect.Array;
import java.util.Iterator;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IInnerList;
import kd.bos.algo.olap.collection.IStorageManager;
import kd.bos.algo.olap.collection.Resetable;
import kd.bos.algo.olap.collection.UnionList;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.util.ObjectComparator;
import kd.bos.algo.olap.util.Sort;

public class ArrayList
implements IInnerList {
    private static int DEFAULT_CAPACITY = 10;
    private Object[] elementData;
    private int size = 0;
    private boolean sorted = false;
    private int ARRAY_BLOCK_SIZE;

    ArrayList() {
        this(DEFAULT_CAPACITY);
    }

    ArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        this.elementData = new Object[capacity];
        this.ARRAY_BLOCK_SIZE = 10000;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    @Override
    public IInnerList innerAddFirst(Object element) {
        return this.innerAdd(0, element);
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.size];
        System.arraycopy(this.elementData, 0, objects, 0, this.size);
        return objects;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object get(int index) {
        this.rangeCheck(index);
        return this.elementData[index];
    }

    @Override
    public Iterator<?> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.size;
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    @Override
    public IInnerList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        Object[] os = new Object[toIndex - fromIndex];
        System.arraycopy(this.elementData, fromIndex, os, 0, toIndex - fromIndex);
        ArrayList list = new ArrayList();
        return list.innerAddArray(os);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object getFirst() {
        return this.get(0);
    }

    @Override
    public Object getLast() {
        return this.get(this.size() - 1);
    }

    public static ArrayList newOne(Object o) {
        ArrayList list = new ArrayList(10);
        list.innerAdd(o);
        return list;
    }

    @Override
    public IInnerList innerAdd(Object o) {
        if (this.size == this.ARRAY_BLOCK_SIZE) {
            return new UnionList(this, ArrayList.newOne(o));
        }
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return this;
    }

    public IInnerList innerAdd(int index, Object o) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (this.size == this.ARRAY_BLOCK_SIZE) {
            if (index == this.size) {
                return new UnionList(this, ArrayList.newOne(o));
            }
            if (index == 0) {
                return new UnionList(ArrayList.newOne(o), this);
            }
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index - 1);
            this.elementData[index] = o;
            return new UnionList(this, ArrayList.newOne(this.elementData[this.size - 1]));
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = o;
        ++this.size;
        return this;
    }

    @Override
    public IInnerList innerAddArray(Object[] objects) {
        if (this.size + objects.length > this.ARRAY_BLOCK_SIZE) {
            Object[] data1 = new Object[this.ARRAY_BLOCK_SIZE - this.size];
            Object[] data2 = new Object[this.size + objects.length - this.ARRAY_BLOCK_SIZE];
            System.arraycopy(objects, 0, data1, 0, data1.length);
            System.arraycopy(objects, data1.length, data2, 0, data2.length);
            IInnerList list1 = this.innerAddArray(data1);
            IInnerList list2 = new ArrayList();
            list2 = list2.innerAddArray(data2);
            return new UnionList(list1, list2);
        }
        this.ensureCapacity(this.size + objects.length);
        for (int i = 0; i < objects.length; ++i) {
            this.elementData[this.size++] = objects[i];
        }
        return this;
    }

    @Override
    public IInnerList innerAddList(IInnerList list) {
        IInnerList list0;
        if (list == this) {
            throw new IllegalArgumentException("List can't addList itself.");
        }
        if (list.size() == 0) {
            return this;
        }
        if (list.size() == 1) {
            return this.innerAdd(list.get(0));
        }
        if (list instanceof ArrayList) {
            return this.innerAddArray(((ArrayList)list).toArray());
        }
        if (list instanceof UnionList && (list0 = ((UnionList)list).getList(0)) instanceof ArrayList) {
            list0 = this.innerAddList(list0);
            IInnerList[] lists = ((UnionList)list).lists;
            IInnerList[] lists2 = new IInnerList[lists.length];
            System.arraycopy(lists, 0, lists2, 0, lists.length);
            lists2[0] = list0;
            return new UnionList(lists2);
        }
        return new UnionList(this, list);
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public IInnerList sort(ObjectComparator comparator) throws OlapException {
        Object[] datas = this.toArray();
        Sort.sort(datas, comparator);
        ArrayList alist = new ArrayList();
        alist.sorted = true;
        return alist.innerAddArray(datas);
    }

    @Override
    public int realSize() {
        return this.size;
    }

    public void doCache(IStorageManager storageManager) {
    }

    @Override
    public IInnerList trimEmpty() {
        Object[] newElements = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.isEmpty(this.elementData[i])) continue;
            newElements[index++] = this.elementData[i];
        }
        this.elementData = newElements;
        this.size = index;
        return this;
    }

    private boolean isEmpty(Object object) {
        block4: {
            block3: {
                if (object instanceof MemberImpl) {
                    MemberImpl member = (MemberImpl)object;
                    return !member.hasData() && !member.maybeNeedCalc();
                }
                if (!(object instanceof MemberImpl[])) break block3;
                for (MemberImpl m : (MemberImpl[])object) {
                    if (m.hasData() || m.maybeNeedCalc()) continue;
                    return true;
                }
                break block4;
            }
            if (!(object instanceof Object[])) break block4;
            for (Object o : (Object[])object) {
                MemberImpl member = (MemberImpl)o;
                if (member.hasData() || member.maybeNeedCalc()) continue;
                return true;
            }
        }
        return false;
    }

    class Itr
    implements Iterator,
    Resetable {
        private int cursor = 0;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size();
        }

        public Object next() {
            Object next = ArrayList.this.get(this.cursor++);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.cursor = 0;
        }
    }
}

