/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.cubedata;

import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.impl.DimensionImpl;

public class CoordsTrans {
    private int[] transDimIndexes;
    private int[] baseline;

    public CoordsTrans(int[] transDimIndexes, Dimension[] dims) {
        this.transDimIndexes = transDimIndexes;
        this.baseline = new int[transDimIndexes.length];
        for (int i = transDimIndexes.length - 1; i >= 0; --i) {
            int cubeDimIndex = transDimIndexes[i];
            DimensionImpl dim = (DimensionImpl)dims[cubeDimIndex];
            this.baseline[i] = dim.getRealMemberCount();
            if (this.baseline[i] != 0) continue;
            this.baseline[i] = dim.getMemberCount();
        }
    }

    public long transform(Member[] members) {
        long l = members[this.transDimIndexes[0]].getGlobalOrder();
        for (int index = 1; index < this.transDimIndexes.length; ++index) {
            int globalOrder = members[this.transDimIndexes[index]].getGlobalOrder();
            if ((l = l * (long)this.baseline[index] + (long)globalOrder) > 0L) continue;
            return -1L;
        }
        return l;
    }

    public long transform(int[] coords) {
        long l = coords[0];
        for (int i = 1; i < coords.length; ++i) {
            if ((l = l * (long)this.baseline[i] + (long)coords[i]) > 0L) continue;
            return -1L;
        }
        return l;
    }
}

