/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.cubedata;

import java.util.ArrayList;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.impl.MemberImpl;

public abstract class DisableAggTester {
    public abstract boolean test(Member[] var1);

    public static DisableAggTester get(Cube cube) {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        Dimension[] dims = cube.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            if (!dims[i].hasDisableAgg()) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return new OneDimensionDisableAggTester((Integer)list.get(0));
        }
        int[] indexes = new int[list.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)list.get(i);
        }
        return new MultiDimensionDisableAggTester(indexes);
    }

    public static class MultiDimensionDisableAggTester
    extends DisableAggTester {
        private int[] dimIndexes;

        public MultiDimensionDisableAggTester(int[] dimIndexes) {
            this.dimIndexes = dimIndexes;
        }

        @Override
        public boolean test(Member[] members) {
            int i;
            boolean b = false;
            for (i = 0; i < this.dimIndexes.length; ++i) {
                if (!((MemberImpl)members[this.dimIndexes[i]]).hasDisableAgg()) continue;
                b = true;
                break;
            }
            if (!b) {
                return false;
            }
            for (i = 0; i < members.length; ++i) {
                if (members[i].isLeaf()) continue;
                return true;
            }
            return false;
        }
    }

    public static class OneDimensionDisableAggTester
    extends DisableAggTester {
        private int dimIndex;

        public OneDimensionDisableAggTester(int dimIndex) {
            this.dimIndex = dimIndex;
        }

        @Override
        public boolean test(Member[] members) {
            boolean b = ((MemberImpl)members[this.dimIndex]).hasDisableAgg();
            if (!b) {
                return false;
            }
            for (int i = 0; i < members.length; ++i) {
                if (i == this.dimIndex || members[i].isLeaf()) continue;
                return true;
            }
            return false;
        }
    }
}

