/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.cubedata;

import java.util.List;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.cubedata.CoordsTrans;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.util.BitSetFactory;
import kd.bos.algo.olap.util.LongBitSet;

public class DisableCalcTester {
    private CoordsTrans coordsTrans;
    private LongBitSet disableCalcBitSet = BitSetFactory.createLongBitSet();

    public DisableCalcTester init(List<String> dimNumbers, Cube cube, List<String[]> disCalcMembers) {
        Dimension[] dimensions = cube.getDimensions();
        int[] dimIndexes = new int[dimNumbers.size()];
        block0: for (int i = 0; i < dimNumbers.size(); ++i) {
            for (int j = 0; j < dimensions.length; ++j) {
                if (!dimNumbers.get(i).equals(dimensions[j].getName())) continue;
                dimIndexes[i] = j;
                continue block0;
            }
        }
        this.coordsTrans = new CoordsTrans(dimIndexes, dimensions);
        int[] keys = new int[dimNumbers.size()];
        for (String[] disCalcMember : disCalcMembers) {
            for (int i = 0; i < disCalcMember.length; ++i) {
                Member member = ((DimensionImpl)dimensions[dimIndexes[i]]).getMemberByName(disCalcMember[i]);
                keys[i] = member.getGlobalOrder();
            }
            long trans = this.coordsTrans.transform(keys);
            this.disableCalcBitSet.set(trans);
        }
        return this;
    }

    public boolean test(Member[] members) {
        long trans = this.coordsTrans.transform(members);
        boolean hasInBitSet = this.disableCalcBitSet.get(trans);
        return hasInBitSet;
    }
}

