/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.def;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.SchemaParser2;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SchemaLoader {
    private static Logger logger = Logger.getLogger(SchemaLoader.class);

    public static SchemaDef load(InputStream in) throws OlapException {
        Document doc;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(in);
        }
        catch (ParserConfigurationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to get document config.", (Throwable)e);
            }
            throw new OlapException("Unable to get document config.", e);
        }
        catch (SAXException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Bad schema document.", (Throwable)e);
            }
            throw new OlapException("Bad schema document.", e);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open the schema input stream.", (Throwable)e);
            }
            throw new OlapException("Unable to open the schema input stream.", e);
        }
        return SchemaParser2.parse(doc);
    }
}

