/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.olap.Cell;
import kd.bos.algo.olap.Connection;
import kd.bos.algo.olap.Database;
import kd.bos.algo.olap.MdxResult;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MetadataAPI;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.Schema;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.MdxResultBase;
import kd.bos.algo.olap.impl.MdxResultImpl;
import kd.bos.algo.olap.impl.MdxResultSimpleImpl;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.mdx.CellReader;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.MdxQuery;
import kd.bos.algo.olap.mdx.ParserHelp;
import kd.bos.algo.olap.mdx.SchemaReader;
import org.apache.log4j.Logger;

public class ConnectionImpl
implements Connection,
Serializable {
    private static final long serialVersionUID = -8852145556892326649L;
    private static Logger logger = Logger.getLogger(ConnectionImpl.class);
    Database database;
    Locale locale;
    int executeModel = 0;
    private Stats stats;
    private String id;
    private HashMap<String, ConnectionImpl> linkCubes = null;
    private MdxQuery mdxQuery;
    private ArrayList<Map<String, Member>> list = null;

    public ConnectionImpl(Database database, Stats stats) {
        if (database == null) {
            throw new NullPointerException();
        }
        this.database = database;
        this.stats = stats;
        this.database.setConnection(this);
        this.id = UUID.randomUUID().toString().replace("-", "");
    }

    public Stats getStats() {
        return this.stats;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Schema getSchema() {
        return this.database.schema;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.database.getSchemaReader();
    }

    @Override
    public SchemaReader getRemoteSchemaReader() {
        return this.database.getSchemaReader();
    }

    @Override
    public MetadataAPI getMetadataAPI() {
        return this.database.getMetadataAPI();
    }

    @Override
    public MdxResult executeMdxQuery(MdxQuery query) throws OlapException {
        return this.executeMdxQuery(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MdxResult executeMdxQuery(MdxQuery query, List<String[]>[] filters) throws OlapException {
        query.setConnection(this);
        this.buildCubeData();
        MdxResultBase result = null;
        try (Stats.StatItem item = this.stats.createStatItem("execute mdx result");){
            result = this.database.getConfig().keepAxisInMdxResult ? new MdxResultImpl(query, filters, this.stats) : new MdxResultSimpleImpl(query, filters, this.stats);
        }
        logger.info((Object)this.stats.toString(this.id));
        return result;
    }

    @Override
    public MdxResult executeMdxQuery(String mdx) throws OlapException {
        return this.executeMdxQuery(mdx, null);
    }

    @Override
    public MdxResult executeMdxQuery(String mdx, List<String[]>[] filters) throws OlapException {
        try {
            return this.executeMdxQuery(this.parseQuery(mdx), filters);
        }
        catch (RuntimeException e) {
            logger.error((Object)("executeMdxQuery error:" + mdx), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("executeMdxQuery error:" + mdx), (Throwable)e);
            throw new OlapException(e);
        }
    }

    @Override
    public MdxQuery parseQuery(String mdx) throws OlapException {
        return ParserHelp.parseQuery(this, mdx, this.stats);
    }

    @Override
    public void close() {
        if (this.database != null) {
            this.database.release();
            this.database = null;
        }
    }

    @Override
    public String getDefaultCubeName() {
        return this.database.getDefaultCubeName();
    }

    @Override
    public Exp parseExpression(String expression) throws OlapException {
        return ParserHelp.parseExpression(expression);
    }

    public CellReader getCellReader(CubeImpl cube) {
        return this.database.getCellReader();
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getExecuteModel() {
        return this.executeModel;
    }

    public void setExecuteModel(int executeModel) {
        this.executeModel = executeModel;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void addLink(String linkName, Connection con) {
        ConnectionImpl cn = (ConnectionImpl)con;
        if (this.linkCubes == null) {
            this.linkCubes = new HashMap(2);
        }
        this.linkCubes.put(linkName, cn);
    }

    public Connection getLink(String linkName) {
        if (this.linkCubes == null) {
            throw new OlapException("link " + linkName + " not found.");
        }
        Connection linkConnection = this.linkCubes.get(linkName);
        if (linkConnection == null) {
            throw new OlapException("link " + linkName + " not found.");
        }
        return linkConnection;
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return this.database.rollUpBuild().getCubeData().cellIterator();
    }

    public void setMdxQuery(MdxQuery mdxQuery) {
        this.mdxQuery = mdxQuery;
    }

    public void buildCubeData() {
        if (this.linkCubes != null) {
            this.list = new ArrayList();
            for (Connection connection : this.linkCubes.values()) {
                ((ConnectionImpl)connection).buildCubeData();
                this.list.add(((ConnectionImpl)connection).getAllMembers());
            }
        }
        this.database.build(this.mdxQuery, this.list);
    }

    private Map<String, Member> getAllMembers() {
        return ((CubeImpl)this.database.getSchemaReader().getCube()).getAllMembers();
    }

    @Override
    public CellReader getCellReader() {
        return this.database.getCellReader();
    }
}

