/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.olap.Aggregator;
import kd.bos.algo.olap.CalculatedMember;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MemberExpression;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.Schema;
import kd.bos.algo.olap.def.CubeDef;
import kd.bos.algo.olap.impl.CalculatedMemberImpl;
import kd.bos.algo.olap.impl.CubeElementBase;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.HierarchyImpl;
import kd.bos.algo.olap.impl.LevelImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.type.CubeType;
import kd.bos.algo.olap.mdx.type.Type;

public class CubeImpl
extends CubeElementBase
implements Cube {
    private static final long serialVersionUID = -8511928525303690149L;
    SchemaImpl schema;
    DimensionImpl[] dims;
    DimensionImpl measureDimension;
    HierarchyImpl measureHierarchy;
    LevelImpl measureLevel;
    MemberImpl[] measures;
    CalculatedMemberImpl[] calculatedMembers;
    MemberExpression[] memberExpressions;
    private CubeDef def;

    public CubeImpl(CubeDef def) {
        this.def = def;
    }

    @Override
    public CubeDef getDef() {
        return this.def;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public void initMeasures(CubeDef x) {
        this.measureLevel = new LevelImpl();
        this.measureLevel.setProperty("name", "MeasuresLevel");
        this.measureDimension = new DimensionImpl();
        this.measureDimension.dimensionType = (byte)-1;
        this.measureDimension.setProperty("name", "Measures");
        if (x.measureDimensionCaption != null) {
            this.measureDimension.setProperty("caption", x.measureDimensionCaption);
        }
        this.measureHierarchy = new HierarchyImpl(this.measureDimension, null, null);
        this.measureHierarchy.setProperty("name", "Measures");
        this.measureDimension.hies = new HierarchyImpl[1];
        this.measureDimension.hies[0] = this.measureHierarchy;
        this.measureHierarchy.levels = new LevelImpl[1];
        this.measureHierarchy.levels[0] = this.measureLevel;
        this.measureLevel.hie = this.measureHierarchy;
        this.measureLevel.levelType = (byte)-2;
    }

    @Override
    public final Dimension[] getDimensions() {
        return this.dims;
    }

    @Override
    public Dimension[] getDimensions(boolean includeMeasures) {
        if (includeMeasures && this.measures != null && this.measures.length > 0) {
            Dimension[] ds = new Dimension[this.dims.length + 1];
            System.arraycopy(this.dims, 0, ds, 0, this.dims.length);
            ds[ds.length - 1] = this.measureDimension;
            return ds;
        }
        return this.dims;
    }

    @Override
    public Dimension getDimension(String name) {
        if (name.equalsIgnoreCase("Measures")) {
            return this.measureDimension;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (!this.dims[i].getName().equalsIgnoreCase(name)) continue;
            return this.dims[i];
        }
        return null;
    }

    @Override
    public Member[] getMeasures() {
        return this.measures;
    }

    @Override
    public int getDimensionOrdinal(String name) throws OlapException {
        if (name.equals("Measures")) {
            return -1;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (!this.dims[i].getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        throw new OlapException("Dimension '" + name + "' not found.");
    }

    @Override
    public Dimension getMeasureDimension() {
        return this.measureDimension;
    }

    @Override
    public Dimension getTimeDimension() {
        for (int i = 0; i < this.dims.length; ++i) {
            if (this.dims[i].dimensionType != 1) continue;
            return this.dims[i];
        }
        return null;
    }

    public Type getExpType() {
        return new CubeType(this);
    }

    public int getCategory() {
        return 12;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) throws OlapException {
        int i;
        Dimension dimension = this.getDimension(name);
        if (dimension != null) {
            return dimension;
        }
        for (i = 0; i < this.measures.length; ++i) {
            if (!this.measures[i].getName().equalsIgnoreCase(name)) continue;
            return this.measures[i];
        }
        for (i = 0; i < this.dims.length; ++i) {
            OlapElement mdxElement = this.dims[i].lookupChild(schemaReader, name);
            if (mdxElement == null) continue;
            return mdxElement;
        }
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.getName();
    }

    @Override
    public Hierarchy getHierarchy() {
        return null;
    }

    @Override
    public Dimension getDimension() {
        return null;
    }

    public Aggregator[] getAggregators() throws OlapException {
        Aggregator[] aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            aggs[i] = Aggregator.getAggregator(aggName);
        }
        return aggs;
    }

    @Override
    public CalculatedMember[] getCalculatedMembers() throws OlapException {
        return this.calculatedMembers;
    }

    @Override
    public MemberExpression[] getMemberExpressions() {
        return this.memberExpressions;
    }

    public Map<String, Member> getAllMembers() {
        HashMap<String, Member> map = new HashMap<String, Member>();
        for (DimensionImpl dim : this.dims) {
            for (Member member : dim.mapOrderToMember.values()) {
                map.put(member.getUniqueName(), (MemberImpl)member);
            }
        }
        return map;
    }
}

