/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Engine;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MemberScope;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.impl.BBFilterIndexes;
import kd.bos.algo.olap.impl.CubeElementBase;
import kd.bos.algo.olap.impl.EvaluateContext;
import kd.bos.algo.olap.impl.HierarchyImpl;
import kd.bos.algo.olap.impl.LeafMemberIterator;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberScopeImpl;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.type.DimensionType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.util.Pair;
import kd.bos.algo.olap.util.UniqueNameUtil;

public class DimensionImpl
extends CubeElementBase
implements Dimension {
    public static final long serialVersionUID = 456721298477547547L;
    HierarchyImpl[] hies;
    byte dimensionType = 0;
    int memberCount;
    Map<Integer, Member> mapOrderToMember = new HashMap<Integer, Member>();
    int realMemberCount;
    Map<Integer, Member> realMapOrderToMember = new HashMap<Integer, Member>();
    boolean isParentChildren = false;
    private boolean hasWeight;
    private boolean hasDisableAgg;
    private HashSet<MemberImpl> calcMembersOfAll = new HashSet(1);
    private HashSet<MemberImpl> calcMembersOfLeaf = new HashSet(1);
    private HashSet<MemberImpl> calcMembersOfNotLeaf = new HashSet(1);
    private int ordinal = -1;
    private transient String uniqueName;
    private HashMap<String, Member> memberCache = null;

    @Override
    public Hierarchy[] getHierarchies() {
        return this.hies;
    }

    @Override
    public Hierarchy getHierarchy(String name) {
        return this.hies[0];
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) throws OlapException {
        return this.getDefaultHierarchy().lookupChild(schemaReader, name);
    }

    @Override
    public Hierarchy getDefaultHierarchy() {
        return this.hies[0];
    }

    @Override
    public byte getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public int getOrdinal(Cube cube) throws OlapException {
        return this.ordinal > 0 ? this.ordinal : (this.ordinal = cube.getDimensionOrdinal(this.name));
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public Iterator<Member> memberIterator() {
        return this.mapOrderToMember.values().iterator();
    }

    public Iterator<Member> leafMemberIterator() {
        return new LeafMemberIterator(this.mapOrderToMember.values().iterator());
    }

    public Type getExpType() {
        return new DimensionType(this);
    }

    public int getCategory() {
        return 2;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameUtil.makeUniqueName(this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public boolean isMeasureDimension() {
        return this.dimensionType == -1;
    }

    @Override
    public boolean isTimeDimension() {
        return this.dimensionType == 1;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.getDefaultHierarchy();
    }

    @Override
    public Dimension getDimension() {
        return this;
    }

    @Override
    public String getCaption() {
        if (this.caption != null) {
            return this.caption;
        }
        if (this.isMeasureDimension()) {
            return Engine.getResource(Locale.getDefault(), "measureDimensionCaption");
        }
        return super.getCaption();
    }

    @Override
    public boolean isParentChildrenDimension() {
        return this.isParentChildren;
    }

    @Override
    public Dimension getDependOnDimension() {
        return (Dimension)this.getProperty("dependOnDimension");
    }

    @Override
    public boolean hasWeight() {
        return this.hasWeight;
    }

    @Override
    public void setHasWeight(boolean b) {
        this.hasWeight = b;
    }

    @Override
    public boolean hasDisableAgg() {
        return this.hasDisableAgg;
    }

    @Override
    public void setHasDisableAgg(boolean hasDisableAgg) {
        this.hasDisableAgg = hasDisableAgg;
    }

    public Member getMemberByName(String memberName) {
        if (this.memberCache == null) {
            this.initMemberCache();
        }
        return this.memberCache.get(memberName);
    }

    private void initMemberCache() {
        HashMap<String, Member> map = new HashMap<String, Member>();
        for (Member member : this.mapOrderToMember.values()) {
            map.put(member.getName(), member);
        }
        this.memberCache = map;
    }

    public void putCalcMemberOfAll(MemberImpl member) {
        this.calcMembersOfAll.add(member);
    }

    public void putCalcMemberOfLeaf(MemberImpl member) {
        this.calcMembersOfLeaf.add(member);
    }

    public Set<MemberImpl> getCalcMembersOfLeaf() {
        return this.calcMembersOfLeaf;
    }

    public void putCalcMemberOfNotLeaf(MemberImpl member) {
        this.calcMembersOfNotLeaf.add(member);
    }

    public boolean hasCalcMembers() {
        return this.calcMembersOfAll.size() > 0 || this.calcMembersOfLeaf.size() > 0 || this.calcMembersOfNotLeaf.size() > 0;
    }

    public void markScopeMembers(Evaluator evaluator) {
        HashSet<MemberScope> duplicated = new HashSet<MemberScope>();
        for (MemberImpl member : this.calcMembersOfAll) {
            this.markScopeMembers0(evaluator, member, duplicated);
        }
        for (MemberImpl member : this.calcMembersOfLeaf) {
            this.markScopeMembers0(evaluator, member, duplicated);
        }
        for (MemberImpl member : this.calcMembersOfNotLeaf) {
            this.markScopeMembers0(evaluator, member, duplicated);
        }
    }

    private void markScopeMembers0(Evaluator evaluator, MemberImpl member, HashSet<MemberScope> duplicated) {
        List<MemberScopeImpl> list = member.getMemberScopes();
        if (list != null) {
            for (MemberScopeImpl scope : list) {
                if (!duplicated.add(scope)) continue;
                this.markScopeMembers1(scope, evaluator);
            }
        }
    }

    private void markScopeMembers1(MemberScopeImpl scope, Evaluator evaluator) {
        if (scope.list.isEmpty()) {
            return;
        }
        EvaluateContext ec = evaluator.getContext();
        Cube cube = ec.getSchemaReader().getCube();
        for (Pair<String, String> pair : scope.list) {
            MemberImpl member;
            String expression = pair.getValue1();
            Exp exp = ec.parseExpression(expression, true);
            Calc calc = ec.compileExpression(exp, false);
            Object value = calc.evaluate(evaluator);
            if (value instanceof IList) {
                Iterator iter = ((IList)value).iterator();
                while (iter.hasNext()) {
                    member = (MemberImpl)iter.next();
                    if (member.isCalculated()) {
                        throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
                    }
                    member.setHasData(true);
                    member.setInScope(true);
                }
                continue;
            }
            if (!(value instanceof Member)) continue;
            member = (MemberImpl)value;
            if (member.isCalculated()) {
                throw new OlapException("Calculated member not support in scope: " + member.getUniqueName());
            }
            member.setHasData(true);
            member.setInScope(true);
        }
    }

    public void rebuildMembers() {
        if (!this.isMeasureDimension()) {
            this.hies[0].buildRealChildren();
            this.rebuildGlobalOrder();
        }
    }

    private void rebuildGlobalOrder() {
        int index = 0;
        for (int i = 0; i < this.memberCount; ++i) {
            MemberImpl member = (MemberImpl)this.mapOrderToMember.get(i);
            if (member.isFake()) {
                member.globalOrder = -1;
                continue;
            }
            member.globalOrder = index++;
            this.realMapOrderToMember.put(member.globalOrder, member);
        }
        this.realMemberCount = index;
    }

    public int getRealMemberCount() {
        return this.realMemberCount;
    }

    public int getRealOrOriginMemberCount() {
        return this.realMemberCount == 0 ? this.memberCount : this.realMemberCount;
    }

    public Map<Integer, Member> getRealMapOrderToMember() {
        return this.realMapOrderToMember;
    }

    @Override
    public BBFilterIndexes buildScopeIndexes(Evaluator evaluator) {
        return null;
    }
}

