/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Engine;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.InnerMemberFactory;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.DefaultListFactory;
import kd.bos.algo.olap.collection.IMemberList;
import kd.bos.algo.olap.impl.CalculatedMemberImpl;
import kd.bos.algo.olap.impl.CubeElementBase;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.InnerMemberFactoryImpl;
import kd.bos.algo.olap.impl.LevelImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberIndex;
import kd.bos.algo.olap.mdx.CacheType;
import kd.bos.algo.olap.mdx.Formula;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.type.HierarchyType;
import kd.bos.algo.olap.mdx.type.Type;

public class HierarchyImpl
extends CubeElementBase
implements Hierarchy {
    public static final long serialVersionUID = 3214563898477547547L;
    DimensionImpl dim;
    LevelImpl[] levels;
    private MemberImpl[] members;
    int memberCount;
    MemberImpl[] realChildren;
    int realMemberCount;
    int depth;
    int ordinal = -1;
    String subName;
    String subCaption;
    String uniqueName;
    private MemberIndex memberIndex;
    private Member defaultMember;
    private MemberImpl nullMember;
    private transient HashMap innerMembers = null;
    private transient LevelImpl innerLevel;
    private transient String allMemberName;
    private transient String allMemberCaption;

    public HierarchyImpl(DimensionImpl dim, String subName, String subCaption) {
        this.dim = dim;
        this.subName = subName;
        this.subCaption = subCaption;
        this.name = dim.getName();
        this.uniqueName = dim.getUniqueName();
        this.caption = dim.getCaption();
        if (this.subCaption != null) {
            this.caption = this.caption + "." + subCaption;
        }
        this.memberIndex = new MemberIndex(dim.isMeasureDimension());
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public Dimension getDimension() {
        return this.dim;
    }

    @Override
    public Level[] getLevels() {
        return this.levels;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public boolean hasAll() {
        return (Boolean)this.getProperty("hasAll", Boolean.TRUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Member getDefaultMember() {
        if (this.defaultMember != null) return this.defaultMember;
        if (this.hasAll() || this.getDimension().isMeasureDimension()) {
            MemberImpl[] ms = this.members;
            if (ms == null || ms.length <= 0) return null;
            this.defaultMember = ms[0];
            return this.defaultMember;
        } else {
            this.defaultMember = this.getInnerAllMember();
        }
        return this.defaultMember;
    }

    public void setMembers(MemberImpl[] members) {
        this.members = members;
        for (int i = 0; i < members.length; ++i) {
            this.memberIndex.put(members[i].getName(), members[i]);
        }
    }

    public MemberImpl[] getRootMembers() {
        return this.members;
    }

    @Override
    public IMemberList getMembers() {
        return DefaultListFactory.instance.createMemberList(this.members);
    }

    public Type getExpType() {
        return new HierarchyType(this);
    }

    public int getCategory() {
        return 3;
    }

    @Override
    public Member getNullMember() {
        if (this.nullMember == null) {
            this.nullMember = new MemberImpl();
            this.nullMember.memberType = (byte)16;
            this.nullMember.level = this.levels[0];
            this.nullMember.setName("#NULL");
        }
        return this.nullMember;
    }

    public LevelImpl lookupLevel(String name) {
        if (name == null) {
            return null;
        }
        if (this.innerLevel != null && this.innerLevel.getName().equalsIgnoreCase(name)) {
            return this.innerLevel;
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (!name.equalsIgnoreCase(this.levels[i].getName())) continue;
            return this.levels[i];
        }
        return null;
    }

    private Map getInnerMembers() {
        if (this.innerMembers == null) {
            this.innerMembers = new HashMap(2, 1.0f);
        }
        return this.innerMembers;
    }

    public LevelImpl getInnerLevel() {
        if (this.innerLevel == null) {
            this.innerLevel = InnerMemberFactoryImpl.createInnerLevel(this);
        }
        return this.innerLevel;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) throws OlapException {
        LevelImpl r = this.lookupLevel(name);
        if (r != null) {
            return r;
        }
        return this.lookupMember(schemaReader, name);
    }

    @Override
    public Member getInnerAllMember() {
        return this.lookupInnerMember("V$ALL");
    }

    @Override
    public Member getInnerOtherMember() {
        return this.lookupInnerMember("V$OTHER");
    }

    public Member lookupInnerMember(String name) {
        Map map = this.getInnerMembers();
        Object member = map.get(name.toUpperCase());
        if (member == null) {
            member = InnerMemberFactoryImpl.createInnerMember(this, name);
            MemberImpl impl = (MemberImpl)member;
            impl.globalOrder = this.memberCount++;
            this.dim.mapOrderToMember.put(impl.globalOrder, impl);
            map.put(name.toUpperCase(), member);
        }
        return (Member)member;
    }

    public OlapElement lookupMember(SchemaReader schemaReader, String name) throws OlapException {
        if (InnerMemberFactory.exists(name)) {
            return this.lookupInnerMember(name);
        }
        return this.memberIndex.get(name);
    }

    public Object[] getChildren() {
        return this.members;
    }

    @Override
    public String getAllMemberName() {
        if (this.allMemberName == null) {
            this.allMemberName = "All " + this.getName();
        }
        return this.allMemberName;
    }

    @Override
    public String getAllMemberCaption() {
        if (this.allMemberCaption == null) {
            this.allMemberCaption = Engine.getResource(Locale.getDefault(), "allMemberCaptionPrefix") + this.getCaption();
        }
        return this.allMemberCaption;
    }

    @Override
    public String getCaption() {
        if (this.dim.isMeasureDimension()) {
            return this.dim.getCaption();
        }
        return super.getCaption();
    }

    @Override
    public Hierarchy getHierarchy() {
        return this;
    }

    @Override
    public Member createMember(String name, String caption, Formula formula, boolean calculatedInSchema) {
        return this.createMember(null, this.levels[0], name, caption, formula, null, calculatedInSchema);
    }

    @Override
    public Member createMember(Member parent, Level level, String name, String caption, Formula formula, CacheType cacheType, boolean calculatedInSchema) {
        return new CalculatedMemberImpl(parent, level, name, caption, formula, cacheType, calculatedInSchema);
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public Member createSlicerCompoundMember(int index, Member[] members) {
        return null;
    }

    @Override
    public String getSubName() {
        return this.subName;
    }

    void addInnerMemberToMembers(MemberImpl member) {
        MemberImpl[] members2 = new MemberImpl[this.members.length + 1];
        System.arraycopy(this.members, 0, members2, 0, this.members.length);
        members2[this.members.length] = member;
        this.members = members2;
    }

    public MemberImpl[] getRealChildren() {
        return this.realChildren;
    }

    public void buildRealChildren() {
        if (this.realChildren != null) {
            return;
        }
        if (this.members == null) {
            return;
        }
        ArrayList<MemberImpl> list = new ArrayList<MemberImpl>();
        for (MemberImpl m : this.members) {
            if (m.realChildren == null) {
                m.buildRealChildren();
            }
            if (m.isFake()) continue;
            list.add(m);
        }
        this.realChildren = list.toArray(new MemberImpl[list.size()]);
    }
}

