/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.util.Util;

public class WeightCalculation {
    private int[] dimIndexes;
    private boolean hasWeight;
    private static Integer i0 = 0;
    private static Integer i1 = 1;
    private static BigDecimal d0 = new BigDecimal(0);
    private static BigDecimal d1 = new BigDecimal(1);

    public WeightCalculation(Cube cube) {
        this.init(cube);
    }

    public WeightCalculation(Member[] members) {
        this.init(members);
    }

    public boolean hasWeight() {
        return this.hasWeight;
    }

    private void init(Cube cube) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>(0);
        Dimension[] dims = cube.getDimensions();
        for (i = 0; i < dims.length; ++i) {
            if (!dims[i].hasWeight()) continue;
            list.add(i);
        }
        if (list.size() > 0) {
            this.dimIndexes = new int[list.size()];
            for (i = 0; i < this.dimIndexes.length; ++i) {
                this.dimIndexes[i] = (Integer)list.get(i);
            }
            this.hasWeight = true;
        }
    }

    private void init(Member[] members) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>(0);
        for (i = 0; i < members.length; ++i) {
            if (!members[i].getDimension().hasWeight()) continue;
            list.add(i);
        }
        if (list.size() > 0) {
            this.dimIndexes = new int[list.size()];
            for (i = 0; i < this.dimIndexes.length; ++i) {
                this.dimIndexes[i] = (Integer)list.get(i);
            }
            this.hasWeight = true;
        }
    }

    public Object calc(Object members, Object value) {
        if (members instanceof Member[]) {
            return this.calc((Member[])members, value);
        }
        return this.calc((Member)members, value);
    }

    public Object calc(Member member, Object value) {
        if (this.dimIndexes == null || value == null) {
            return value;
        }
        Number weight = member.getWeight();
        if (weight == null || i1.equals(weight) || d1.equals(weight)) {
            return value;
        }
        if (i0.equals(weight) || d0.equals(weight)) {
            return null;
        }
        BigDecimal bd = weight instanceof BigDecimal ? (BigDecimal)weight : BigDecimal.valueOf(weight.intValue());
        return Util.toBigDecimal(value).multiply(bd);
    }

    public Object calc(Member[] members, Object value) {
        if (this.dimIndexes == null || value == null) {
            return value;
        }
        if (this.dimIndexes.length == 1) {
            Number weight = members[this.dimIndexes[0]].getWeight();
            if (weight == null || i1.equals(weight) || d1.equals(weight)) {
                return value;
            }
            if (i0.equals(weight) || d0.equals(weight)) {
                return null;
            }
            BigDecimal bd = weight instanceof BigDecimal ? (BigDecimal)weight : BigDecimal.valueOf(weight.intValue());
            return Util.toBigDecimal(value).multiply(bd);
        }
        BigDecimal bd = d1;
        for (int i = 0; i < this.dimIndexes.length; ++i) {
            Number weight = members[this.dimIndexes[i]].getWeight();
            if (weight == null || i1.equals(weight) || d1.equals(weight)) continue;
            if (i0.equals(weight) || d0.equals(weight)) {
                return null;
            }
            bd = weight instanceof BigDecimal ? bd.multiply((BigDecimal)weight) : bd.multiply(BigDecimal.valueOf(weight.intValue()));
        }
        return Util.toBigDecimal(value).multiply(bd);
    }

    public Object[] calc(Member[] members, Object[] values, int index) {
        if (this.dimIndexes == null || values == null || values.length == 1 && values[0] == null) {
            return values;
        }
        Number weight = members[index].getWeight();
        if (weight == null || i1.equals(weight) || d1.equals(weight)) {
            return values;
        }
        if (i0.equals(weight) || d0.equals(weight)) {
            return null;
        }
        BigDecimal bd = weight instanceof BigDecimal ? (BigDecimal)weight : BigDecimal.valueOf(weight.intValue());
        Object[] newValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = values[i] != null ? Util.toBigDecimal(values[i]).multiply(bd) : values[i];
        }
        return newValues;
    }

    public Object calc(Member[] members, Object value, int index) {
        if (this.dimIndexes == null || value == null) {
            return value;
        }
        Number weight = members[index].getWeight();
        if (weight == null || i1.equals(weight) || d1.equals(weight)) {
            return value;
        }
        if (i0.equals(weight) || d0.equals(weight)) {
            return null;
        }
        BigDecimal bd = weight instanceof BigDecimal ? (BigDecimal)weight : BigDecimal.valueOf(weight.intValue());
        return Util.toBigDecimal(value).multiply(bd);
    }
}

