/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.QueryObject;
import kd.bos.algo.olap.util.UniqueNameUtil;

public class DimensionProperty
extends QueryObject {
    private Dimension dimension;
    private Level level;
    private String property;

    public DimensionProperty(Dimension dimension, Level level, String property) {
        this.dimension = dimension;
        this.level = level;
        this.property = property;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getProperty() {
        return this.property;
    }

    void resolve(ExpResolver resolver) throws OlapException {
        resolver.resolve(this);
    }

    @Override
    public String toMdx() {
        StringBuilder sb = new StringBuilder();
        UniqueNameUtil.quoteMdxIdentifier(this.dimension.getName(), sb);
        sb.append(".");
        if (this.level != null) {
            UniqueNameUtil.quoteMdxIdentifier(this.level.getName(), sb);
            sb.append(".");
        }
        UniqueNameUtil.quoteMdxIdentifier(this.property, sb);
        return sb.toString();
    }
}

