/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.io.Serializable;
import java.util.List;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Level;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.Property;
import kd.bos.algo.olap.mdx.CompoundId;
import kd.bos.algo.olap.mdx.DimensionProperty;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.QueryObject;
import kd.bos.algo.olap.mdx.SchemaLookup;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;

public class QueryAxis
extends QueryObject
implements Serializable {
    private String name;
    private boolean nonEmpty;
    private boolean fact;
    private Exp exp;
    private List dimProps;
    private DimensionProperty[] resolvedProps;

    public QueryAxis(boolean nonEmpty, boolean fact, Exp exp, String name) {
        this.nonEmpty = nonEmpty;
        this.fact = fact;
        this.exp = exp;
        this.name = name;
    }

    public Exp getExp() {
        return this.exp;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public boolean isNonFactEmpty() {
        return this.nonEmpty && this.fact;
    }

    public void setExp(Exp exp) {
        this.exp = exp;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public void setNonFactEmpty(boolean b) {
        this.nonEmpty = b;
        this.fact = b;
    }

    public boolean isRow() {
        return "Rows".equalsIgnoreCase(this.name);
    }

    public boolean isColumn() {
        return "Columns".equalsIgnoreCase(this.name);
    }

    @Override
    public String toMdx() {
        StringBuilder sb = new StringBuilder();
        if (this.nonEmpty) {
            if (this.fact) {
                sb.append("NON FACT EMPTY ");
            } else {
                sb.append("NON EMPTY ");
            }
        }
        sb.append(this.exp.toMdx());
        if (this.dimProps != null && this.dimProps.size() > 0) {
            sb.append(" DIMENSION PROPERTIES ");
            for (int i = 0; i < this.dimProps.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(((CompoundId)this.dimProps.get(i)).toMdx());
            }
        } else if (this.resolvedProps != null && this.resolvedProps.length > 0) {
            sb.append(" DIMENSION PROPERTIES ");
            for (int i = 0; i < this.resolvedProps.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.resolvedProps[i].toMdx());
            }
        }
        sb.append(" ON ");
        sb.append(this.name);
        return sb.toString();
    }

    public Object clone() {
        QueryAxis qa = new QueryAxis(this.nonEmpty, this.fact, (Exp)this.exp.clone(), this.name);
        qa.setDimProps(this.dimProps);
        return qa;
    }

    public List getDimProps() {
        return this.dimProps;
    }

    public void setDimProps(List dimProps) {
        this.dimProps = dimProps;
    }

    public DimensionProperty[] getResolvedProps() {
        return this.resolvedProps;
    }

    public void setResolvedProps(DimensionProperty[] resolvedProps) {
        this.resolvedProps = resolvedProps;
    }

    public void resolve(ExpResolver resolver) throws OlapException {
        this.exp = resolver.resolve(this.exp);
        if (!this.exp.isSet()) {
            throw new OlapException("Query axis " + this.name + " is not a Set.");
        }
        this.resolveDimProperties(resolver);
    }

    private void resolveDimProperties(ExpResolver resolver) throws OlapException {
        if (this.dimProps == null || this.dimProps.size() == 0) {
            return;
        }
        int len = this.dimProps.size();
        this.resolvedProps = new DimensionProperty[len];
        block0: for (int i = 0; i < len; ++i) {
            Hierarchy hie;
            CompoundId id = (CompoundId)this.dimProps.get(i);
            String[] names = id.toStringArray();
            if (names.length < 2) {
                throw new OlapException("Dimension Property " + id.toMdx() + " is not correct,it must be as [Dimension].[Level].[Property] or [Dimension].[Property].");
            }
            String[] n2 = new String[names.length - 1];
            System.arraycopy(names, 0, n2, 0, names.length - 1);
            SchemaReader schemaReader = resolver.getSchemaReader();
            OlapElement ele = SchemaLookup.lookupCompound(schemaReader, schemaReader.getCube(), n2, 0);
            if (ele == null) {
                throw new OlapException("Dimension Property " + id.toMdx() + " is not correct,it must be as [Dimension].[Level].[Property] or [Dimension].[Property].");
            }
            if (ele instanceof Level) {
                Level level = (Level)ele;
                Property[] props = level.getMemberProperties();
                if (props == null) continue;
                for (int k = 0; k < props.length; ++k) {
                    if (!names[names.length - 1].equalsIgnoreCase(props[k].getName())) continue;
                    this.resolvedProps[i] = new DimensionProperty(level.getDimension(), level, props[k].getName());
                    continue block0;
                }
                continue;
            }
            if (ele instanceof Dimension) {
                hie = ((Dimension)ele).getDefaultHierarchy();
            } else if (ele instanceof Hierarchy) {
                Level level;
                hie = (Hierarchy)ele;
                if (n2.length == 2 && n2[0].equalsIgnoreCase(n2[1]) && (level = SchemaLookup.lookupHierarchyLevel(hie, n2[1])) != null) {
                    Property[] props = level.getMemberProperties();
                    if (props == null) continue;
                    for (int k = 0; k < props.length; ++k) {
                        if (!names[names.length - 1].equalsIgnoreCase(props[k].getName())) continue;
                        this.resolvedProps[i] = new DimensionProperty(hie.getDimension(), level, props[k].getName());
                        continue block0;
                    }
                    continue;
                }
            } else {
                throw new OlapException("Dimension Property " + id.toMdx() + " is not correct,it must be as [Dimension].[Level].[Property] or [Dimension].[Property].");
            }
            for (int j = 0; j < hie.getLevels().length; ++j) {
                Level level = hie.getLevels()[j];
                Property[] props = level.getMemberProperties();
                if (props == null) continue;
                for (int k = 0; k < props.length; ++k) {
                    if (!names[names.length - 1].equalsIgnoreCase(props[k].getName())) continue;
                    this.resolvedProps[i] = new DimensionProperty(hie.getDimension(), level, props[k].getName());
                    continue block0;
                }
            }
            throw new OlapException("Dimension Property " + id.toMdx() + " not found,it must be as [Dimension].[Level].[Property] or [Dimension].[Property].");
        }
        this.dimProps = null;
    }

    public Calc compile(ExpCompiler compiler) throws OlapException {
        return compiler.compile(this.exp);
    }
}

