/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.mdx.DimensionProperty;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.Formula;
import kd.bos.algo.olap.mdx.MemberProperty;
import kd.bos.algo.olap.mdx.QueryAxis;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.UserDefineFunTable;

public class StackExpResolver
implements ExpResolver {
    private final Stack stack = new Stack();
    private Set resolvedNodes = new HashSet();
    private SchemaReader schemaReader;
    private UserDefineFunTable udfTable;

    public StackExpResolver(SchemaReader schemaReader, UserDefineFunTable udfTable) {
        this.schemaReader = schemaReader;
        this.udfTable = udfTable;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    @Override
    public UserDefineFunTable getUdfTable() {
        return this.udfTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exp resolve(Exp exp) throws OlapException {
        if (!this.resolvedNodes.add(exp)) {
            return exp;
        }
        this.stack.push(exp);
        try {
            Exp resolved = exp.resolve(this);
            this.resolvedNodes.add(resolved);
            Exp exp2 = resolved;
            return exp2;
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(MemberProperty memberProperty) throws OlapException {
        if (!this.resolvedNodes.add(memberProperty)) {
            return;
        }
        this.stack.push(memberProperty);
        try {
            memberProperty.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(DimensionProperty dimensionProperty) throws OlapException {
        if (!this.resolvedNodes.add(dimensionProperty)) {
            return;
        }
        this.stack.push(dimensionProperty);
        try {
            dimensionProperty.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(QueryAxis axis) throws OlapException {
        if (!this.resolvedNodes.add(axis)) {
            return;
        }
        this.stack.push(axis);
        try {
            axis.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }

    @Override
    public void resolve(Formula formula) throws OlapException {
        if (!this.resolvedNodes.add(formula)) {
            return;
        }
        this.stack.push(formula);
        try {
            formula.resolve(this);
        }
        finally {
            this.stack.pop();
        }
    }
}

