/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.mdx.calc.impl;

import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.IList;
import kd.bos.algo.olap.collection.ListFactoryFactory;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ExpResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.DimensionCalc;
import kd.bos.algo.olap.mdx.calc.DummyExp;
import kd.bos.algo.olap.mdx.calc.ExpCompiler;
import kd.bos.algo.olap.mdx.calc.HierarchyCalc;
import kd.bos.algo.olap.mdx.calc.LevelCalc;
import kd.bos.algo.olap.mdx.calc.ListCalc;
import kd.bos.algo.olap.mdx.calc.MemberCalc;
import kd.bos.algo.olap.mdx.calc.StringCalc;
import kd.bos.algo.olap.mdx.calc.TupleCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractListCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractMemberCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractStringCalc;
import kd.bos.algo.olap.mdx.calc.impl.AbstractTupleCalc;
import kd.bos.algo.olap.mdx.calc.impl.MemberValueCalc;
import kd.bos.algo.olap.mdx.calc.impl.TupleValueCalc;
import kd.bos.algo.olap.mdx.func.DimensionCurrentMemberFunDef;
import kd.bos.algo.olap.mdx.func.HierarchyCurrentMemberFunDef;
import kd.bos.algo.olap.mdx.func.HierarchyDimensionFunDef;
import kd.bos.algo.olap.mdx.func.LevelHierarchyFunDef;
import kd.bos.algo.olap.mdx.func.MemberHierarchyFunDef;
import kd.bos.algo.olap.mdx.func.MemberLevelFunDef;
import kd.bos.algo.olap.mdx.type.BooleanType;
import kd.bos.algo.olap.mdx.type.DimensionType;
import kd.bos.algo.olap.mdx.type.HierarchyType;
import kd.bos.algo.olap.mdx.type.LevelType;
import kd.bos.algo.olap.mdx.type.MemberType;
import kd.bos.algo.olap.mdx.type.NumericType;
import kd.bos.algo.olap.mdx.type.ScalarType;
import kd.bos.algo.olap.mdx.type.StringType;
import kd.bos.algo.olap.mdx.type.TupleType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.mdx.type.TypeUtil;
import kd.bos.algo.olap.util.Util;

public abstract class AbstractExpCompiler
implements ExpCompiler {
    private final ExpResolver resolver;

    public AbstractExpCompiler(ExpResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public Calc compile(Exp exp) throws OlapException {
        if (exp == null) {
            return null;
        }
        return exp.compile(this);
    }

    @Override
    public MemberCalc compileMember(Exp exp) throws OlapException {
        Type type = exp.getType();
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            return new DimensionCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(type)), dimensionCalc);
        }
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(TypeUtil.toMemberType(type)), hierarchyCalc);
        }
        if (type instanceof MemberType) {
            final Calc calc = this.compile(exp);
            if (calc instanceof MemberCalc) {
                return (MemberCalc)calc;
            }
            return new AbstractMemberCalc(exp, new Calc[]{calc}){

                @Override
                public Member evaluateMember(Evaluator evaluator) throws OlapException {
                    Object o = calc.evaluate(evaluator);
                    if (o == null || o instanceof Member) {
                        return (Member)o;
                    }
                    throw new OlapException("Can't cast " + this.exp.toMdx() + " to Member.");
                }
            };
        }
        throw new OlapException("Can't cast " + exp.toMdx() + " to Member.");
    }

    @Override
    public LevelCalc compileLevel(Exp exp) throws OlapException {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberLevelFunDef.CalcImpl((Exp)new DummyExp(LevelType.forType(type)), memberCalc);
        }
        assert (type instanceof LevelType);
        return (LevelCalc)this.compile(exp);
    }

    @Override
    public DimensionCalc compileDimension(Exp exp) throws OlapException {
        Type type = exp.getType();
        if (type instanceof HierarchyType) {
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            return new HierarchyDimensionFunDef.CalcImpl(exp, hierarchyCalc);
        }
        return (DimensionCalc)this.compile(exp);
    }

    @Override
    public HierarchyCalc compileHierarchy(Exp exp) throws OlapException {
        Type type = exp.getType();
        if (type instanceof DimensionType || type instanceof MemberType) {
            MemberCalc memberCalc = this.compileMember(exp);
            return new MemberHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), memberCalc);
        }
        if (type instanceof LevelType) {
            LevelCalc levelCalc = this.compileLevel(exp);
            return new LevelHierarchyFunDef.CalcImpl((Exp)new DummyExp(HierarchyType.forType(type)), levelCalc);
        }
        assert (type instanceof HierarchyType);
        return (HierarchyCalc)this.compile(exp);
    }

    @Override
    public StringCalc compileString(Exp exp) throws OlapException {
        final Calc calc = this.compile(exp);
        if (calc instanceof StringCalc) {
            return (StringCalc)calc;
        }
        return new AbstractStringCalc(exp, new Calc[]{calc}){

            @Override
            public String evaluateString(Evaluator evaluator) throws OlapException {
                Object value = calc.evaluate(evaluator);
                if (value == null || value == Util.nullValue) {
                    return "";
                }
                return value.toString();
            }
        };
    }

    @Override
    public ListCalc compileList(Exp exp) throws OlapException {
        final Calc calc = this.compile(exp);
        if (calc instanceof ListCalc) {
            return (ListCalc)calc;
        }
        return new AbstractListCalc(exp, new Calc[]{calc}){

            @Override
            public IList evaluateList(Evaluator evaluator) throws OlapException {
                IList list = ListFactoryFactory.getListFactory().createArrayList();
                Object value = calc.evaluate(evaluator);
                if (!(value instanceof Member) && !(value instanceof Member[])) {
                    throw new OlapException("can't cast " + this.exp.toMdx() + " to List.");
                }
                list.add(value);
                return list;
            }
        };
    }

    @Override
    public TupleCalc compileTuple(Exp exp) throws OlapException {
        final Calc calc = this.compile(exp);
        if (calc instanceof TupleCalc) {
            return (TupleCalc)calc;
        }
        return new AbstractTupleCalc(exp, new Calc[]{calc}){

            @Override
            public Member[] evaluateTuple(Evaluator evaluator) throws OlapException {
                Object value = calc.evaluate(evaluator);
                if (value instanceof Member) {
                    return new Member[]{(Member)value};
                }
                throw new OlapException("can't cast " + this.exp.toMdx() + " to Tuple.");
            }
        };
    }

    @Override
    public Calc compileScalar(Exp exp, boolean convert) throws OlapException {
        Type type = exp.getType();
        if (type instanceof MemberType) {
            MemberType memberType = (MemberType)type;
            MemberCalc calc = this.compileMember(exp);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{calc});
        }
        if (type instanceof DimensionType) {
            DimensionCalc dimensionCalc = this.compileDimension(exp);
            MemberType memberType = MemberType.forType(type);
            DimensionCurrentMemberFunDef.CalcImpl dimensionCurrentMemberCalc = new DimensionCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(memberType), dimensionCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{dimensionCurrentMemberCalc});
        }
        if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            MemberType memberType = MemberType.forHierarchy(hierarchyType.getHierarchy());
            HierarchyCalc hierarchyCalc = this.compileHierarchy(exp);
            HierarchyCurrentMemberFunDef.CalcImpl hierarchyCurrentMemberCalc = new HierarchyCurrentMemberFunDef.CalcImpl((Exp)new DummyExp(type), hierarchyCalc);
            return new MemberValueCalc(new DummyExp(memberType.getValueType()), new MemberCalc[]{hierarchyCurrentMemberCalc});
        }
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            TupleCalc tupleCalc = this.compileTuple(exp);
            TupleValueCalc scalarCalc = new TupleValueCalc(new DummyExp(tupleType.getValueType()), tupleCalc);
            return scalarCalc;
        }
        if (type instanceof ScalarType) {
            if (convert) {
                if (type instanceof BooleanType) {
                    return this.compileBoolean(exp);
                }
                if (type instanceof NumericType) {
                    return this.compileBigDecimal(exp);
                }
                if (type instanceof StringType) {
                    return this.compileString(exp);
                }
                return this.compile(exp);
            }
            return this.compile(exp);
        }
        return this.compile(exp);
    }

    @Override
    public ExpResolver getResolver() {
        return this.resolver;
    }
}

